/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public abstract class PlatformCapabilityBase<S extends Enum<S>>
extends PlatformCapability<S> {
    public static final String LIBCXXABI_PREFIX = "libc++abi.";
    public static final String LIBCXX_PREFIX = "libc++.";
    protected final boolean loadCxxLibraries;

    public PlatformCapabilityBase(Class<S> cls, boolean loadCxxLibraries) {
        super(cls);
        this.loadCxxLibraries = loadCxxLibraries;
    }

    @Override
    public String[] getSulongDefaultLibraries() {
        if (this.loadCxxLibraries) {
            return new String[]{this.getLibsulongFilename(), this.getLibsulongxxFilename()};
        }
        return new String[]{this.getLibsulongFilename()};
    }

    public abstract String getLibsulongxxFilename();

    public abstract String getLibsulongFilename();

    @Override
    public List<String> preprocessDependencies(LLVMContext ctx, TruffleFile file, List<String> dependencies) {
        ArrayList<String> newDeps = null;
        boolean libSulongXXAdded = false;
        if (file != null && ctx.isInternalLibraryFile(file)) {
            Path path = Paths.get(file.getPath(), new String[0]);
            String remainder = ctx.getInternalLibraryPath().relativize(path).toString();
            if (remainder.startsWith(LIBCXXABI_PREFIX) || remainder.startsWith(LIBCXX_PREFIX)) {
                newDeps = new ArrayList<String>(dependencies);
                newDeps.add(this.getLibsulongxxFilename());
                libSulongXXAdded = true;
            }
        }
        for (int i = 0; i < dependencies.size(); ++i) {
            String filename;
            Path namePath;
            String dep = dependencies.get(i);
            if (dep.startsWith("/usr/lib/libc++") && (namePath = Paths.get(dep, new String[0]).getFileName()) != null && ((filename = namePath.toString()).startsWith(LIBCXX_PREFIX) || filename.startsWith(LIBCXXABI_PREFIX))) {
                if (newDeps == null) {
                    newDeps = new ArrayList<String>(dependencies);
                }
                newDeps.set(i, filename);
                dep = filename;
            }
            if (libSulongXXAdded || !dep.startsWith(LIBCXXABI_PREFIX) && !dep.startsWith(LIBCXX_PREFIX)) continue;
            if (newDeps == null) {
                newDeps = new ArrayList<String>(dependencies);
            }
            newDeps.add(this.getLibsulongxxFilename());
            libSulongXXAdded = true;
        }
        if (newDeps != null) {
            return newDeps;
        }
        return dependencies;
    }
}

