/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories;

import com.oracle.truffle.llvm.parser.factories.DarwinAMD64PlatformCapability;
import com.oracle.truffle.llvm.parser.factories.LinuxAArch64PlatformCapability;
import com.oracle.truffle.llvm.parser.factories.LinuxAMD64PlatformCapability;
import com.oracle.truffle.llvm.parser.factories.PlatformCapabilityBase;
import com.oracle.truffle.llvm.parser.factories.UnknownBasicPlatformCapability;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMInfo;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMNativeSyscallNode;
import java.nio.file.Path;
import java.nio.file.Paths;

public abstract class BasicPlatformCapability<S extends Enum<S>>
extends PlatformCapabilityBase<S> {
    private static final Path SULONG_LIBDIR = Paths.get("native", "lib");
    public static final String LIBSULONG_FILENAME = "libsulong." + NativeContextExtension.getNativeLibrarySuffix();
    public static final String LIBSULONGXX_FILENAME = "libsulong++." + NativeContextExtension.getNativeLibrarySuffix();

    public static BasicPlatformCapability<?> create(boolean loadCxxLibraries) {
        if (LLVMInfo.SYSNAME.equalsIgnoreCase("linux")) {
            if (LLVMInfo.MACHINE.equalsIgnoreCase("x86_64")) {
                return new LinuxAMD64PlatformCapability(loadCxxLibraries);
            }
            if (LLVMInfo.MACHINE.equalsIgnoreCase("aarch64")) {
                return new LinuxAArch64PlatformCapability(loadCxxLibraries);
            }
        }
        if (LLVMInfo.SYSNAME.equalsIgnoreCase("mac os x") && LLVMInfo.MACHINE.equalsIgnoreCase("x86_64")) {
            return new DarwinAMD64PlatformCapability(loadCxxLibraries);
        }
        return new UnknownBasicPlatformCapability(loadCxxLibraries);
    }

    protected BasicPlatformCapability(Class<S> cls, boolean loadCxxLibraries) {
        super(cls, loadCxxLibraries);
    }

    @Override
    public String getBuiltinsLibrary() {
        return "libgraalvm-llvm." + NativeContextExtension.getNativeLibrarySuffixVersioned(1);
    }

    @Override
    public Path getSulongLibrariesPath() {
        return SULONG_LIBDIR;
    }

    @Override
    public String getLibsulongxxFilename() {
        return LIBSULONGXX_FILENAME;
    }

    @Override
    public String getLibsulongFilename() {
        return LIBSULONG_FILENAME;
    }

    @Override
    public LLVMSyscallOperationNode createSyscallNode(long index) {
        try {
            return this.createSyscallNode(this.getSyscall(index));
        }
        catch (IllegalArgumentException e) {
            return new LLVMNativeSyscallNode(index);
        }
    }

    @Override
    public String getLibrarySuffix() {
        return NativeContextExtension.getNativeLibrarySuffix();
    }

    protected abstract LLVMSyscallOperationNode createSyscallNode(S var1);
}

