/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

public abstract class ValueList<V extends Value<V, C>, C extends ValueVisitor<V>> {
    private static final int GLOBAL_SCOPE_START = -1;
    private final PlaceholderFactory<V, C> placeholderFactory;
    private final HashMap<Integer, ForwardReference> forwardReferences;
    private final BitSet unresolvedIndices;
    private int scopeStart;
    private final ArrayList<V> valueList;

    public static void dropLocalScope(int localScopeStart, List<?> valueList) {
        if (localScopeStart >= 0 && valueList.size() - localScopeStart > 0) {
            valueList.subList(localScopeStart, valueList.size()).clear();
        }
    }

    protected ValueList(PlaceholderFactory<V, C> placeholderFactory) {
        this.placeholderFactory = placeholderFactory;
        this.valueList = new ArrayList();
        this.forwardReferences = new HashMap();
        this.unresolvedIndices = new BitSet();
        this.scopeStart = -1;
    }

    private void resolveForwardReference(int valueIndex, V newValue) {
        this.forwardReferences.remove(valueIndex).resolve(newValue);
    }

    private ForwardReference getReference(int valueIndex) {
        ForwardReference fwdRef = this.forwardReferences.get(valueIndex);
        if (fwdRef != null) {
            return fwdRef;
        }
        fwdRef = new ForwardReference(this, this.placeholderFactory.newValue());
        this.forwardReferences.put(valueIndex, fwdRef);
        this.unresolvedIndices.set(valueIndex);
        return fwdRef;
    }

    public void add(V newValue) {
        int valueIndex = this.valueList.size();
        this.valueList.add(newValue);
        if (this.unresolvedIndices.get(valueIndex)) {
            this.unresolvedIndices.set(valueIndex, false);
            this.resolveForwardReference(valueIndex, newValue);
        }
    }

    public V getForwardReferenced(int index, V dependent) {
        if (index >= 0 && index < this.valueList.size()) {
            return (V)((Value)this.valueList.get(index));
        }
        ForwardReference ref = this.getReference(index);
        ref.addDependent(dependent);
        return ref.getPlaceholder();
    }

    public V getOrNull(int index) {
        if (index >= 0 && index < this.valueList.size()) {
            return (V)((Value)this.valueList.get(index));
        }
        return null;
    }

    public void onParse(int index, Consumer<V> action) {
        if (index < this.valueList.size()) {
            action.accept((Value)this.valueList.get(index));
        } else {
            this.getReference(index).addCallBack(action);
        }
    }

    public void startScope() {
        this.scopeStart = this.valueList.size();
    }

    public void endScope() {
        ValueList.dropLocalScope(this.scopeStart, this.valueList);
        this.scopeStart = -1;
    }

    public int size() {
        return this.valueList.size();
    }

    public void accept(C visitor) {
        for (Value value : this.valueList) {
            value.accept(visitor);
        }
    }

    private static final class ForwardReference {
        private final V placeholder;
        private final HashSet<V> dependents;
        private final HashSet<Consumer<V>> callBacks;
        final /* synthetic */ ValueList this$0;

        ForwardReference(V placeholder) {
            this.this$0 = var1_1;
            this.placeholder = placeholder;
            this.dependents = new HashSet();
            this.callBacks = new HashSet();
        }

        V getPlaceholder() {
            return this.placeholder;
        }

        void addDependent(V dependent) {
            this.dependents.add(dependent);
        }

        void addCallBack(Consumer<V> callBack) {
            this.callBacks.add(callBack);
        }

        void resolve(V value) {
            for (Value value2 : this.dependents) {
                value2.replace(this.placeholder, value);
            }
            for (Consumer consumer : this.callBacks) {
                consumer.accept(value);
            }
        }
    }

    public static interface PlaceholderFactory<V extends Value<V, C>, C extends ValueVisitor<V>> {
        public V newValue();
    }

    public static interface Value<V, C extends ValueVisitor<V>> {
        public void replace(V var1, V var2);

        public void accept(C var1);
    }

    public static interface ValueVisitor<V> {
        default public void defaultAction(V v) {
        }
    }
}

