/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;

public abstract class StaticInitsNode
extends LLVMStatementNode {
    @Node.Children
    private final LLVMStatementNode[] statements;
    private final Object moduleName;
    private final String prefix;

    public StaticInitsNode(LLVMStatementNode[] statements, String prefix, Object moduleName) {
        this.statements = statements;
        this.prefix = prefix;
        this.moduleName = moduleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExplodeLoop
    @Specialization
    public void doInit(VirtualFrame frame, @CachedContext(value=LLVMLanguage.class) LLVMContext ctx) {
        LLVMContext lLVMContext = ctx;
        synchronized (lLVMContext) {
            if (ctx.loaderTraceStream() != null) {
                this.traceExecution(ctx);
            }
            for (LLVMStatementNode stmt : this.statements) {
                stmt.execute(frame);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void traceExecution(LLVMContext ctx) {
        LibraryLocator.traceStaticInits(ctx, this.prefix, this.moduleName, String.format("[%d inst]", this.statements.length));
    }
}

