/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.initialization.InitializeExternalNode;
import com.oracle.truffle.llvm.initialization.InitializeGlobalNode;
import com.oracle.truffle.llvm.initialization.InitializeModuleNode;
import com.oracle.truffle.llvm.initialization.InitializeOverwriteNode;
import com.oracle.truffle.llvm.initialization.InitializeScopeNode;
import com.oracle.truffle.llvm.initialization.InitializeSymbolsNode;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMLocalScope;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.SulongLibrary;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRootNode;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.List;

public final class LoadModulesNode
extends LLVMRootNode {
    private static final String MAIN_METHOD_NAME = "main";
    @CompilerDirectives.CompilationFinal
    RootCallTarget mainFunctionCallTarget = null;
    final String sourceName;
    final int bitcodeID;
    final Source source;
    @CompilerDirectives.CompilationFinal
    TruffleLanguage.ContextReference<LLVMContext> ctxRef;
    @Node.Child
    LLVMStatementNode initContext;
    @Node.Child
    InitializeSymbolsNode initSymbols;
    @Node.Child
    InitializeScopeNode initScopes;
    @Node.Child
    InitializeExternalNode initExternals;
    @Node.Child
    InitializeGlobalNode initGlobals;
    @Node.Child
    InitializeOverwriteNode initOverwrite;
    @Node.Child
    InitializeModuleNode initModules;
    @Node.Child
    IndirectCallNode indirectCall;
    @Node.Child
    IndirectCallNode callDependencies;
    final CallTarget[] dependencies;
    final List<Object> dependenciesSource;
    final LLVMParserRuntime parserRuntime;
    final LLVMLanguage language;
    private boolean hasInitialised;
    @CompilerDirectives.CompilationFinal
    private SulongLibrary.CachedMainFunction main;

    private LoadModulesNode(String name, LLVMParserResult parserResult, boolean isInternalSulongLibrary, FrameDescriptor rootFrame, boolean lazyParsing, List<Object> dependenciesSource, Source source, LLVMLanguage language) throws Type.TypeOverflowException {
        super(language, rootFrame, parserResult.getRuntime().getNodeFactory().createStackAccess(rootFrame));
        this.sourceName = name;
        this.source = source;
        this.bitcodeID = parserResult.getRuntime().getBitcodeID();
        this.parserRuntime = parserResult.getRuntime();
        this.dependenciesSource = dependenciesSource;
        this.language = language;
        this.dependencies = new CallTarget[dependenciesSource.size()];
        this.hasInitialised = false;
        this.initContext = null;
        String moduleName = parserResult.getRuntime().getLibraryName();
        this.initSymbols = new InitializeSymbolsNode(parserResult, lazyParsing, isInternalSulongLibrary, moduleName);
        this.initScopes = new InitializeScopeNode(this.parserRuntime);
        this.initExternals = new InitializeExternalNode(parserResult);
        this.initGlobals = new InitializeGlobalNode(parserResult, moduleName);
        this.initOverwrite = new InitializeOverwriteNode(parserResult);
        this.initModules = new InitializeModuleNode(language, parserResult, moduleName);
        this.indirectCall = IndirectCallNode.create();
        this.callDependencies = IndirectCallNode.create();
    }

    public String getName() {
        return '<' + ((Object)((Object)this)).getClass().getSimpleName() + '>';
    }

    public SourceSection getSourceSection() {
        return this.source.createUnavailableSection();
    }

    public static LoadModulesNode create(String name, LLVMParserResult parserResult, boolean lazyParsing, boolean isInternalSulongLibrary, List<Object> dependencySources, Source source, LLVMLanguage language) {
        try {
            return new LoadModulesNode(name, parserResult, isInternalSulongLibrary, new FrameDescriptor(), lazyParsing, dependencySources, source, language);
        }
        catch (Type.TypeOverflowException e) {
            throw new LLVMUnsupportedException(null, LLVMUnsupportedException.UnsupportedReason.UNSUPPORTED_VALUE_RANGE, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(VirtualFrame frame) {
        LLVMContext context;
        if (this.ctxRef == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.ctxRef = this.lookupContextReference(LLVMLanguage.class);
        }
        LLVMContext lLVMContext = context = (LLVMContext)this.ctxRef.get();
        synchronized (lLVMContext) {
            LLVMScope scope;
            if (!this.hasInitialised) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                for (int i = 0; i < this.dependenciesSource.size(); ++i) {
                    if (this.dependenciesSource.get(i) instanceof Source) {
                        CallTarget callTarget;
                        this.dependencies[i] = callTarget = context.getEnv().parseInternal((Source)this.dependenciesSource.get(i), new String[0]);
                        continue;
                    }
                    if (this.dependenciesSource.get(i) instanceof CallTarget) {
                        this.dependencies[i] = (CallTarget)this.dependenciesSource.get(i);
                        continue;
                    }
                    throw new IllegalStateException("Unknown dependency.");
                }
                LLVMFunction mainFunction = this.findMainFunction();
                this.main = mainFunction != null ? new SulongLibrary.CachedMainFunction(mainFunction) : null;
                this.initContext = (LLVMStatementNode)this.insert(this.language.createInitializeContextNode());
                this.hasInitialised = true;
            }
            if ((scope = this.loadModule(frame, context)) != null) {
                return new SulongLibrary(this.sourceName, scope, this.main, context);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLVMScope loadModule(VirtualFrame frame, LLVMContext context) {
        this.stackAccess.executeEnter(frame, ((LLVMContext)this.ctxRef.get()).getThreadingStack().getStack());
        try {
            CallTarget[] callTargetArray;
            BitSet visited;
            LLVMLoadingPhase phase;
            LLVMLocalScope localScope = null;
            ArrayDeque que = null;
            CallTarget[] resultScope = null;
            if (frame.getArguments().length > 0 && frame.getArguments()[0] instanceof LLVMLoadingPhase) {
                phase = (LLVMLoadingPhase)((Object)frame.getArguments()[0]);
                visited = (BitSet)frame.getArguments()[1];
                if (phase == LLVMLoadingPhase.BUILD_SCOPES || phase == LLVMLoadingPhase.INIT_EXTERNALS || phase == LLVMLoadingPhase.INIT_OVERWRITE) {
                    localScope = (LLVMLocalScope)frame.getArguments()[2];
                }
                if (phase == LLVMLoadingPhase.BUILD_SCOPES) {
                    que = (ArrayDeque)frame.getArguments()[3];
                    resultScope = (LLVMScope)frame.getArguments()[4];
                }
            } else if (frame.getArguments().length == 0 || !(frame.getArguments()[0] instanceof LLVMLoadingPhase)) {
                phase = LLVMLoadingPhase.ALL;
                resultScope = LoadModulesNode.createLLVMScope();
                localScope = LoadModulesNode.createLocalScope();
                context.addLocalScope(localScope);
                visited = this.createBitset();
                que = new ArrayDeque();
            } else {
                throw new LLVMParserException("LoadModulesNode is called with unexpected arguments");
            }
            if (LLVMLoadingPhase.BUILD_SCOPES.isActive(phase) && !visited.get(this.bitcodeID)) {
                visited.set(this.bitcodeID);
                LoadModulesNode.addIDToLocalScope(localScope, this.bitcodeID);
                this.initScopes.execute(context, localScope);
                resultScope.addMissingEntries(this.parserRuntime.getFileScope());
                for (CallTarget callTarget : this.dependencies) {
                    if (callTarget == null) continue;
                    LoadModulesNode.queAdd(que, callTarget);
                }
                if (LLVMLoadingPhase.ALL.isActive(phase)) {
                    while (!que.isEmpty()) {
                        this.indirectCall.call((CallTarget)que.poll(), new Object[]{LLVMLoadingPhase.BUILD_SCOPES, visited, localScope, que, resultScope});
                    }
                }
            }
            if (context.isLibraryAlreadyLoaded(this.bitcodeID)) {
                callTargetArray = resultScope;
                return callTargetArray;
            }
            if (LLVMLoadingPhase.INIT_SYMBOLS.isActive(phase)) {
                if (LLVMLoadingPhase.ALL == phase) {
                    visited.clear();
                }
                this.executeInitialiseSymbol(context, visited);
            }
            if (LLVMLoadingPhase.INIT_EXTERNALS.isActive(phase)) {
                if (LLVMLoadingPhase.ALL == phase) {
                    visited.clear();
                }
                this.executeInitialiseExternal(context, visited, localScope);
            }
            if (LLVMLoadingPhase.INIT_GLOBALS.isActive(phase)) {
                if (LLVMLoadingPhase.ALL == phase) {
                    visited.clear();
                }
                this.executeInitialiseGlobals(context, visited, frame);
            }
            if (LLVMLoadingPhase.INIT_OVERWRITE.isActive(phase)) {
                if (LLVMLoadingPhase.ALL == phase) {
                    visited.clear();
                }
                this.executeInitialiseOverwrite(context, visited, localScope);
            }
            if (LLVMLoadingPhase.INIT_CONTEXT.isActive(phase)) {
                if (LLVMLoadingPhase.ALL == phase) {
                    visited.clear();
                }
                this.executeInitialiseContext(visited, frame);
            }
            if (LLVMLoadingPhase.INIT_MODULE.isActive(phase)) {
                if (LLVMLoadingPhase.ALL == phase) {
                    visited.clear();
                }
                this.executeInitialiseModule(context, visited, frame);
            }
            if (LLVMLoadingPhase.INIT_DONE.isActive(phase)) {
                if (LLVMLoadingPhase.ALL == phase) {
                    visited.clear();
                }
                this.executeDone(context, visited);
            }
            if (LLVMLoadingPhase.ALL == phase) {
                callTargetArray = resultScope;
                return callTargetArray;
            }
            callTargetArray = null;
            return callTargetArray;
        }
        finally {
            this.stackAccess.executeExit(frame);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void executeInitialiseSymbol(LLVMContext context, BitSet visited) {
        if (!visited.get(this.bitcodeID)) {
            visited.set(this.bitcodeID);
            for (CallTarget d : this.dependencies) {
                if (d == null) continue;
                this.callDependencies.call(d, new Object[]{LLVMLoadingPhase.INIT_SYMBOLS, visited});
            }
            this.initSymbols.initializeSymbolTable(context);
            this.initSymbols.execute(context);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void executeInitialiseExternal(LLVMContext context, BitSet visited, LLVMLocalScope localScope) {
        if (!visited.get(this.bitcodeID)) {
            visited.set(this.bitcodeID);
            for (CallTarget d : this.dependencies) {
                if (d == null) continue;
                this.callDependencies.call(d, new Object[]{LLVMLoadingPhase.INIT_EXTERNALS, visited, localScope});
            }
            this.initExternals.execute(context, localScope);
        }
    }

    private void executeInitialiseGlobals(LLVMContext context, BitSet visited, VirtualFrame frame) {
        if (!visited.get(this.bitcodeID)) {
            visited.set(this.bitcodeID);
            for (CallTarget d : this.dependencies) {
                if (d == null) continue;
                this.callDependencies.call(d, new Object[]{LLVMLoadingPhase.INIT_GLOBALS, visited});
            }
            this.initGlobals.execute(frame, context.getReadOnlyGlobals(this.bitcodeID));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void executeInitialiseOverwrite(LLVMContext context, BitSet visited, LLVMLocalScope localScope) {
        if (!visited.get(this.bitcodeID)) {
            visited.set(this.bitcodeID);
            for (CallTarget d : this.dependencies) {
                if (d == null) continue;
                this.callDependencies.call(d, new Object[]{LLVMLoadingPhase.INIT_OVERWRITE, visited, localScope});
            }
        }
        this.initOverwrite.execute(context, localScope);
    }

    private void executeInitialiseContext(BitSet visited, VirtualFrame frame) {
        if (!visited.get(this.bitcodeID)) {
            visited.set(this.bitcodeID);
            for (CallTarget d : this.dependencies) {
                if (d == null) continue;
                this.callDependencies.call(d, new Object[]{LLVMLoadingPhase.INIT_CONTEXT, visited});
            }
            this.initContext.execute(frame);
        }
    }

    private void executeInitialiseModule(LLVMContext context, BitSet visited, VirtualFrame frame) {
        if (!visited.get(this.bitcodeID)) {
            visited.set(this.bitcodeID);
            for (CallTarget d : this.dependencies) {
                if (d == null) continue;
                this.callDependencies.call(d, new Object[]{LLVMLoadingPhase.INIT_MODULE, visited});
            }
            this.initModules.execute(frame, context);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void executeDone(LLVMContext context, BitSet visited) {
        if (!visited.get(this.bitcodeID)) {
            visited.set(this.bitcodeID);
            for (CallTarget d : this.dependencies) {
                if (d == null) continue;
                this.callDependencies.call(d, new Object[]{LLVMLoadingPhase.INIT_DONE, visited});
            }
            context.markLibraryLoaded(this.bitcodeID);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void queAdd(ArrayDeque<CallTarget> que, CallTarget callTarget) {
        que.add(callTarget);
    }

    @CompilerDirectives.TruffleBoundary
    private BitSet createBitset() {
        return new BitSet(this.dependencies.length);
    }

    @CompilerDirectives.TruffleBoundary
    private static void addIDToLocalScope(LLVMLocalScope localScope, int id) {
        localScope.addID(id);
    }

    @CompilerDirectives.TruffleBoundary
    private static LLVMLocalScope createLocalScope() {
        return new LLVMLocalScope();
    }

    @CompilerDirectives.TruffleBoundary
    private static LLVMScope createLLVMScope() {
        return new LLVMScope();
    }

    private LLVMFunction findMainFunction() {
        LLVMFunction mainFunction;
        LLVMScope fileScope = this.parserRuntime.getFileScope();
        LLVMSymbol mainSymbol = fileScope.get(MAIN_METHOD_NAME);
        if (mainSymbol != null && mainSymbol.isFunction() && ((mainFunction = mainSymbol.asFunction()).getFunction() instanceof LLVMFunctionCode.LLVMIRFunction || mainFunction.getFunction() instanceof LLVMFunctionCode.LazyLLVMIRFunction)) {
            return mainFunction;
        }
        return null;
    }

    protected static enum LLVMLoadingPhase {
        ALL,
        BUILD_SCOPES,
        INIT_SYMBOLS,
        INIT_EXTERNALS,
        INIT_GLOBALS,
        INIT_MODULE,
        INIT_CONTEXT,
        INIT_OVERWRITE,
        INIT_DONE;


        boolean isActive(LLVMLoadingPhase phase) {
            return phase == this || phase == ALL;
        }
    }
}

