/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.memory.LLVMAllocateNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayList;
import java.util.List;

public final class InitializeSymbolsNode
extends LLVMNode {
    private final String moduleName;
    @Node.Child
    private LLVMAllocateNode allocRoSection;
    @Node.Child
    private LLVMAllocateNode allocRwSection;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] globalOffsets;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final boolean[] globalIsReadOnly;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMSymbol[] globals;
    @Node.Children
    private final AllocSymbolNode[] allocFuncs;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMSymbol[] functions;
    private final LLVMScope fileScope;
    private final NodeFactory nodeFactory;
    private final int bitcodeID;
    private final int globalLength;

    public InitializeSymbolsNode(LLVMParserResult result, boolean lazyParsing, boolean isInternalSulongLibrary, String moduleName) throws Type.TypeOverflowException {
        DataLayout dataLayout = result.getDataLayout();
        this.nodeFactory = result.getRuntime().getNodeFactory();
        this.fileScope = result.getRuntime().getFileScope();
        this.globalLength = result.getSymbolTableSize();
        this.bitcodeID = result.getRuntime().getBitcodeID();
        this.moduleName = moduleName;
        DataSection roSection = new DataSection(dataLayout);
        DataSection rwSection = new DataSection(dataLayout);
        List<GlobalVariable> definedGlobals = result.getDefinedGlobals();
        int globalsCount = definedGlobals.size();
        this.globalOffsets = new int[globalsCount];
        this.globalIsReadOnly = new boolean[globalsCount];
        this.globals = new LLVMSymbol[globalsCount];
        LLVMIntrinsicProvider intrinsicProvider = LLVMLanguage.getLanguage().getCapability(LLVMIntrinsicProvider.class);
        for (int i = 0; i < globalsCount; ++i) {
            LLVMSymbol symbol;
            GlobalVariable global = definedGlobals.get(i);
            Type type = global.getType().getPointeeType();
            if (InitializeSymbolsNode.isSpecialGlobalSlot(type)) {
                this.globalOffsets[i] = -1;
            } else {
                if (type.getSize(dataLayout) == 0L) {
                    type = PrimitiveType.getIntegerType(8);
                }
                this.globalIsReadOnly[i] = global.isReadOnly();
                DataSection dataSection = this.globalIsReadOnly[i] ? roSection : rwSection;
                long offset = dataSection.add(global, type);
                assert (offset >= 0L);
                if (offset > Integer.MAX_VALUE) {
                    throw CompilerDirectives.shouldNotReachHere((String)"globals section >2GB not supported");
                }
                this.globalOffsets[i] = (int)offset;
            }
            this.globals[i] = symbol = this.fileScope.get(global.getName());
        }
        List<FunctionSymbol> definedFunctions = result.getDefinedFunctions();
        int functionCount = definedFunctions.size();
        this.functions = new LLVMSymbol[functionCount];
        this.allocFuncs = new AllocSymbolNode[functionCount];
        for (int i = 0; i < functionCount; ++i) {
            FunctionSymbol functionSymbol = definedFunctions.get(i);
            LLVMFunction function = this.fileScope.getFunction(functionSymbol.getName());
            LLVMFunctionCode functionCode = new LLVMFunctionCode(function);
            this.allocFuncs[i] = isInternalSulongLibrary && intrinsicProvider.isIntrinsified(function.getName()) ? new AllocIntrinsicFunctionNode(function, functionCode, this.nodeFactory, intrinsicProvider) : (lazyParsing ? new AllocLLVMFunctionNode(function, functionCode) : new AllocLLVMEagerFunctionNode(function, functionCode));
            this.functions[i] = function;
        }
        this.allocRoSection = roSection.getAllocateNode(this.nodeFactory, "roglobals_struct", true);
        this.allocRwSection = rwSection.getAllocateNode(this.nodeFactory, "rwglobals_struct", false);
    }

    public void initializeSymbolTable(LLVMContext context) {
        context.initializeSymbolTable(this.bitcodeID, this.globalLength);
        context.registerScope(this.fileScope);
    }

    public LLVMPointer execute(LLVMContext ctx) {
        if (ctx.loaderTraceStream() != null) {
            LibraryLocator.traceStaticInits(ctx, "symbol initializers", this.moduleName);
        }
        LLVMPointer roBase = InitializeSymbolsNode.allocOrNull(this.allocRoSection);
        LLVMPointer rwBase = InitializeSymbolsNode.allocOrNull(this.allocRwSection);
        this.allocGlobals(ctx, roBase, rwBase);
        this.allocFunctions(ctx);
        if (this.allocRoSection != null) {
            ctx.registerReadOnlyGlobals(this.bitcodeID, roBase, this.nodeFactory);
        }
        if (this.allocRwSection != null) {
            ctx.registerGlobals(rwBase, this.nodeFactory);
        }
        return roBase;
    }

    private void allocGlobals(LLVMContext context, LLVMPointer roBase, LLVMPointer rwBase) {
        for (int i = 0; i < this.globals.length; ++i) {
            LLVMPointer ref;
            LLVMSymbol allocGlobal = this.globals[i];
            LLVMGlobal descriptor = this.fileScope.getGlobalVariable(allocGlobal.getName());
            if (descriptor == null) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(String.format("Global variable %s not found", allocGlobal.getName()));
            }
            if (context.checkSymbol(allocGlobal)) continue;
            if (this.globalOffsets[i] == -1) {
                ref = LLVMManagedPointer.create(new LLVMGlobalContainer());
            } else {
                LLVMPointer base = this.globalIsReadOnly[i] ? roBase : rwBase;
                ref = base.increment(this.globalOffsets[i]);
            }
            context.initializeSymbol(this.globals[i], ref);
            ArrayList<LLVMSymbol> list = new ArrayList<LLVMSymbol>(1);
            list.add(descriptor);
            context.registerSymbolReverseMap(list, ref);
        }
    }

    private void allocFunctions(LLVMContext context) {
        for (int i = 0; i < this.allocFuncs.length; ++i) {
            AllocSymbolNode allocSymbol = this.allocFuncs[i];
            LLVMPointer pointer = allocSymbol.allocate(context);
            context.initializeSymbol(this.functions[i], pointer);
            ArrayList<LLVMSymbol> list = new ArrayList<LLVMSymbol>(1);
            list.add(allocSymbol.symbol);
            context.registerSymbolReverseMap(list, pointer);
        }
    }

    private static LLVMPointer allocOrNull(LLVMAllocateNode allocNode) {
        if (allocNode != null) {
            return allocNode.executeWithTarget();
        }
        return null;
    }

    private static void addPaddingTypes(ArrayList<Type> result, int padding) {
        int size;
        assert (padding >= 0);
        for (int remaining = padding; remaining > 0; remaining -= size) {
            size = Math.min(8, Integer.highestOneBit(remaining));
            result.add(PrimitiveType.getIntegerType(size * 8));
        }
    }

    private static boolean isSpecialGlobalSlot(Type type) {
        return type instanceof PointerType;
    }

    private static int getAlignment(DataLayout dataLayout, GlobalVariable global, Type type) {
        return global.getAlign() > 0 ? 1 << global.getAlign() - 1 : type.getAlignment(dataLayout);
    }

    static final class AllocIntrinsicFunctionNode
    extends AllocSymbolNode {
        private final NodeFactory nodeFactory;
        LLVMIntrinsicProvider intrinsicProvider;
        private final LLVMFunctionCode functionCode;

        AllocIntrinsicFunctionNode(LLVMFunction function, LLVMFunctionCode functionCode, NodeFactory nodeFactory, LLVMIntrinsicProvider intrinsicProvider) {
            super(function);
            this.functionCode = functionCode;
            this.nodeFactory = nodeFactory;
            this.intrinsicProvider = intrinsicProvider;
        }

        @CompilerDirectives.TruffleBoundary
        private LLVMFunctionDescriptor createAndDefine(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = context.createFunctionDescriptor(this.symbol.asFunction(), this.functionCode);
            if (this.intrinsicProvider.isIntrinsified(this.symbol.getName())) {
                functionDescriptor.getFunctionCode().define(this.intrinsicProvider, this.nodeFactory);
                return functionDescriptor;
            }
            throw new IllegalStateException("Failed to allocate intrinsic function " + this.symbol.getName());
        }

        @Override
        LLVMPointer allocate(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = this.createAndDefine(context);
            return LLVMManagedPointer.create(functionDescriptor);
        }
    }

    static final class AllocLLVMEagerFunctionNode
    extends AllocSymbolNode {
        private final LLVMFunctionCode functionCode;

        AllocLLVMEagerFunctionNode(LLVMFunction function, LLVMFunctionCode functionCode) {
            super(function);
            this.functionCode = functionCode;
        }

        @CompilerDirectives.TruffleBoundary
        private LLVMFunctionDescriptor createAndResolve(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = context.createFunctionDescriptor(this.symbol.asFunction(), this.functionCode);
            functionDescriptor.getFunctionCode().resolveIfLazyLLVMIRFunction();
            return functionDescriptor;
        }

        @Override
        LLVMPointer allocate(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = this.createAndResolve(context);
            return LLVMManagedPointer.create(functionDescriptor);
        }
    }

    static final class AllocLLVMFunctionNode
    extends AllocSymbolNode {
        private final LLVMFunctionCode functionCode;

        AllocLLVMFunctionNode(LLVMFunction function, LLVMFunctionCode functionCode) {
            super(function);
            this.functionCode = functionCode;
        }

        @CompilerDirectives.TruffleBoundary
        private LLVMFunctionDescriptor createAndResolve(LLVMContext context) {
            return context.createFunctionDescriptor(this.symbol.asFunction(), this.functionCode);
        }

        @Override
        LLVMPointer allocate(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = this.createAndResolve(context);
            return LLVMManagedPointer.create(functionDescriptor);
        }
    }

    static abstract class AllocSymbolNode
    extends LLVMNode {
        static final AllocSymbolNode[] EMPTY = new AllocSymbolNode[0];
        final LLVMSymbol symbol;

        AllocSymbolNode(LLVMSymbol symbol) {
            this.symbol = symbol;
        }

        abstract LLVMPointer allocate(LLVMContext var1);
    }

    static final class DataSection {
        final DataLayout dataLayout;
        final ArrayList<Type> types = new ArrayList();
        private long offset = 0L;

        DataSection(DataLayout dataLayout) {
            this.dataLayout = dataLayout;
        }

        long add(GlobalVariable global, Type type) throws Type.TypeOverflowException {
            int alignment = InitializeSymbolsNode.getAlignment(this.dataLayout, global, type);
            int padding = Type.getPadding(this.offset, alignment);
            InitializeSymbolsNode.addPaddingTypes(this.types, padding);
            long ret = this.offset = Type.addUnsignedExact(this.offset, padding);
            this.types.add(type);
            this.offset = Type.addUnsignedExact(this.offset, type.getSize(this.dataLayout));
            return ret;
        }

        LLVMAllocateNode getAllocateNode(NodeFactory factory, String typeName, boolean readOnly) {
            if (this.offset > 0L) {
                StructureType structType = StructureType.createNamedFromList(typeName, true, this.types);
                return factory.createAllocateGlobalsBlock(structType, readOnly);
            }
            return null;
        }
    }
}

