/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.initialization.AllocExternalSymbolNode;
import com.oracle.truffle.llvm.initialization.AllocExternalSymbolNodeFactory;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.model.GlobalSymbol;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMLocalScope;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.ArrayList;

public final class InitializeExternalNode
extends LLVMNode {
    @Node.Children
    private final AllocExternalSymbolNode[] allocExternalSymbols;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMSymbol[] symbols;
    private final NodeFactory nodeFactory;

    public InitializeExternalNode(LLVMParserResult result) {
        this.nodeFactory = result.getRuntime().getNodeFactory();
        LLVMScope fileScope = result.getRuntime().getFileScope();
        ArrayList<LLVMSymbol> symbolsList = new ArrayList<LLVMSymbol>();
        ArrayList<AllocExternalSymbolNode.AllocExistingLocalSymbolsNode.AllocExistingGlobalSymbolsNode> allocExternaSymbolsList = new ArrayList<AllocExternalSymbolNode.AllocExistingLocalSymbolsNode.AllocExistingGlobalSymbolsNode>();
        for (FunctionSymbol functionSymbol : result.getExternalFunctions()) {
            String name = functionSymbol.getName();
            LLVMFunction function = fileScope.getFunction(name);
            LLVMFunctionCode functionCode = new LLVMFunctionCode(function);
            if (name.startsWith("llvm.") || name.startsWith("__builtin_") || name.equals("polyglot_get_arg") || name.equals("polyglot_get_arg_count")) continue;
            allocExternaSymbolsList.add(AllocExternalSymbolNodeFactory.AllocExistingLocalSymbolsNodeGen.AllocExistingGlobalSymbolsNodeGen.AllocExternalFunctionNodeGen.create(function, functionCode, this.nodeFactory));
            symbolsList.add(function);
        }
        for (GlobalSymbol globalSymbol : result.getExternalGlobals()) {
            LLVMGlobal global = fileScope.getGlobalVariable(globalSymbol.getName());
            allocExternaSymbolsList.add(AllocExternalSymbolNodeFactory.AllocExistingLocalSymbolsNodeGen.AllocExistingGlobalSymbolsNodeGen.AllocExternalGlobalNodeGen.create(global));
            symbolsList.add(global);
        }
        this.symbols = symbolsList.toArray(LLVMSymbol.EMPTY);
        this.allocExternalSymbols = allocExternaSymbolsList.toArray(AllocExternalSymbolNode.EMPTY);
    }

    @ExplodeLoop
    public void execute(LLVMContext context, LLVMLocalScope localScope) {
        LLVMScope globalScope = context.getGlobalScope();
        LLVMIntrinsicProvider intrinsicProvider = LLVMLanguage.getLanguage().getCapability(LLVMIntrinsicProvider.class);
        NativeContextExtension nativeContextExtension = InitializeExternalNode.getNativeContextExtension(context);
        for (int i = 0; i < this.allocExternalSymbols.length; ++i) {
            AllocExternalSymbolNode function = this.allocExternalSymbols[i];
            LLVMPointer pointer = function.execute(localScope, globalScope, intrinsicProvider, nativeContextExtension, context);
            if (pointer == null) continue;
            context.initializeSymbol(this.symbols[i], pointer);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static NativeContextExtension getNativeContextExtension(LLVMContext context) {
        return context.getContextExtensionOrNull(NativeContextExtension.class);
    }
}

