/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.asm.amd64;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.asm.amd64.AsmOperand;
import com.oracle.truffle.llvm.runtime.types.Type;

class AsmImmediateOperand
implements AsmOperand {
    private final String val;
    private final long ival;
    private final boolean label;

    AsmImmediateOperand(long value) {
        this.val = null;
        this.ival = value;
        this.label = false;
    }

    AsmImmediateOperand(String value) {
        this.val = value;
        this.ival = 0L;
        this.label = true;
    }

    public String getLabel() {
        if (!this.isLabel()) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("not a label!");
        }
        return this.val;
    }

    public long getValue() {
        if (this.isLabel()) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("is a label!");
        }
        return this.ival;
    }

    public boolean isLabel() {
        return this.label;
    }

    @Override
    public Type getType() {
        return null;
    }

    public String toString() {
        return this.isLabel() ? this.getLabel() : Long.toUnsignedString(this.getValue());
    }
}

