/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.CXXDemangler;
import com.oracle.truffle.llvm.initialization.LoadModulesNode;
import com.oracle.truffle.llvm.initialization.LoadNativeNode;
import com.oracle.truffle.llvm.parser.LLVMParser;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.binary.BinaryParser;
import com.oracle.truffle.llvm.parser.binary.BinaryParserResult;
import com.oracle.truffle.llvm.parser.model.ModelModule;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.parser.model.target.TargetDataLayout;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.parser.scanner.LLVMScanner;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.DefaultLibraryLocator;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.LLVMSourceContext;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceFileReference;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.graalvm.polyglot.io.ByteSequence;

final class ParserDriver {
    private final LLVMContext context;
    private final LLVMLanguage language;
    private final AtomicInteger nextFreeBitcodeID;
    private final ArrayList<Object> dependencies = new ArrayList();
    static final String SULONG_RENAME_MARKER = "___sulong_import_";
    static final int SULONG_RENAME_MARKER_LEN = "___sulong_import_".length();

    public static CallTarget parse(LLVMContext context, AtomicInteger bitcodeID, Source source) {
        return new ParserDriver(context, bitcodeID).parseWithDependencies(source);
    }

    private ParserDriver(LLVMContext context, AtomicInteger moduleID) {
        this.context = context;
        this.language = context.getLanguage();
        this.nextFreeBitcodeID = moduleID;
    }

    private CallTarget parseWithDependencies(Source source) {
        if (!source.hasBytes()) {
            if (source.hasCharacters()) {
                throw new LLVMParserException("Unexpected character-based source with mime type: " + source.getMimeType());
            }
            throw new LLVMParserException("Should not reach here: Source is neither char-based nor byte-based!");
        }
        ByteSequence bytes = source.getBytes();
        return this.parseWithDependencies(source, bytes);
    }

    private CallTarget parseWithDependencies(Source source, ByteSequence bytes) {
        this.insertDefaultDependencies(source.getName());
        LLVMParserResult result = this.parseLibraryWithSource(source, bytes);
        if (result == null) {
            TruffleFile file = this.createNativeTruffleFile(source.getName(), source.getPath());
            if (file == null) {
                return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode((Object)0));
            }
            return this.createNativeLibraryCallTarget(file);
        }
        if (this.context.isInternalLibraryFile(result.getRuntime().getFile())) {
            String libraryName = ParserDriver.getSimpleLibraryName(source.getName());
            this.language.addInternalFileScope(libraryName, result.getRuntime().getFileScope());
            if (libraryName.equals("libsulong")) {
                this.context.addLibsulongDataLayout(result.getDataLayout());
            }
            this.resolveRenamedSymbols(result);
        }
        ParserDriver.addExternalSymbolsToScopes(result);
        return this.createLibraryCallTarget(source.getName(), result, source);
    }

    @CompilerDirectives.TruffleBoundary
    private TruffleFile createNativeTruffleFile(String libName, String libPath) {
        NativeContextExtension nativeContextExtension = this.context.getContextExtensionOrNull(NativeContextExtension.class);
        if (nativeContextExtension != null) {
            TruffleFile file = DefaultLibraryLocator.INSTANCE.locate(this.context, libName, "<native library>");
            if (file == null) {
                LibraryLocator.traceDelegateNative(this.context, libPath);
                file = this.context.getEnv().getInternalTruffleFile(libPath);
            }
            return file;
        }
        return null;
    }

    private void insertDefaultDependencies(String currentLib) {
        String[] sulongLibraryNames;
        for (String sulongLibraryName : sulongLibraryNames = this.language.getCapability(PlatformCapability.class).getSulongDefaultLibraries()) {
            TruffleFile file;
            if (currentLib.equals(sulongLibraryName) || (file = this.createTruffleFile(sulongLibraryName, null, LLVMContext.InternalLibraryLocator.INSTANCE, "<internal library>")) == null) continue;
            CallTarget calls = this.language.getCachedLibrary(file.getPath());
            if (calls != null) {
                this.dependencies.add(calls);
                continue;
            }
            Object sourceOrCallTarget = this.createDependencySource(sulongLibraryName, null, false, file);
            if (sourceOrCallTarget == null || this.dependencies.contains(sourceOrCallTarget)) continue;
            this.dependencies.add(sourceOrCallTarget);
        }
        List<String> externals = SulongEngineOption.getPolyglotOptionExternalLibraries(this.context.getEnv());
        for (String externalLibraryName : externals) {
            TruffleFile file;
            if (currentLib.equals(externalLibraryName) || (file = this.createTruffleFile(externalLibraryName, null, DefaultLibraryLocator.INSTANCE, "<command-line library>")) == null) continue;
            CallTarget calls = this.language.getCachedLibrary(file.getPath());
            if (calls != null) {
                this.dependencies.add(calls);
                continue;
            }
            Object sourceOrCallTarget = this.createDependencySource(externalLibraryName, externalLibraryName, true, file);
            if (sourceOrCallTarget == null || this.dependencies.contains(sourceOrCallTarget)) continue;
            this.dependencies.add(sourceOrCallTarget);
        }
    }

    protected void resolveRenamedSymbols(LLVMParserResult parserResult) {
        ListIterator<FunctionSymbol> it = parserResult.getExternalFunctions().listIterator();
        while (it.hasNext()) {
            String originalName;
            TruffleFile file;
            String libName;
            LLVMScope scope;
            String lib;
            FunctionSymbol external = it.next();
            String name = external.getName();
            if (name.startsWith(SULONG_RENAME_MARKER)) {
                int idx = name.indexOf(95, SULONG_RENAME_MARKER_LEN);
                if (idx <= 0) continue;
                lib = name.substring(SULONG_RENAME_MARKER_LEN, idx);
                scope = this.language.getInternalFileScopes(ParserDriver.getSimpleLibraryName(lib));
                if (scope == null) {
                    try {
                        libName = lib + "." + this.language.getCapability(PlatformCapability.class).getLibrarySuffix();
                        file = this.createTruffleFile(libName, null, LLVMContext.InternalLibraryLocator.INSTANCE, "<default bitcode library>");
                        this.context.getEnv().parseInternal(Source.newBuilder((String)"llvm", (TruffleFile)file).internal(this.context.isInternalLibraryFile(file)).build(), new String[0]);
                        scope = this.language.getInternalFileScopes(ParserDriver.getSimpleLibraryName(lib));
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                if (scope == null) {
                    throw new LLVMLinkerException(String.format("The symbol %s could not be imported because library %s was not found during symbol renaming", external.getName(), lib));
                }
                originalName = name.substring(idx + 1);
                ParserDriver.createNewFunction(scope, originalName, parserResult, external, lib, name, it);
                continue;
            }
            if (!CXXDemangler.isRenamedNamespaceSymbol(name)) continue;
            ArrayList<String> namespaces = CXXDemangler.decodeNamespace(name);
            lib = CXXDemangler.getAndRemoveLibraryName(namespaces);
            scope = this.language.getInternalFileScopes(ParserDriver.getSimpleLibraryName(lib));
            if (scope == null) {
                try {
                    libName = lib + "." + this.language.getCapability(PlatformCapability.class).getLibrarySuffix();
                    file = this.createTruffleFile(libName, null, LLVMContext.InternalLibraryLocator.INSTANCE, "<default bitcode library>");
                    this.context.getEnv().parseInternal(Source.newBuilder((String)"llvm", (TruffleFile)file).internal(this.context.isInternalLibraryFile(file)).build(), new String[0]);
                    scope = this.language.getInternalFileScopes(ParserDriver.getSimpleLibraryName(lib));
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            if (scope == null) {
                throw new LLVMLinkerException(String.format("The symbol %s could not be imported because library %s was not found during symbol renaming", external.getName(), lib));
            }
            originalName = CXXDemangler.encodeNamespace(namespaces);
            ParserDriver.createNewFunction(scope, originalName, parserResult, external, lib, name, it);
        }
    }

    private static void createNewFunction(LLVMScope scope, String originalName, LLVMParserResult parserResult, FunctionSymbol external, String lib, String name, ListIterator<FunctionSymbol> it) {
        LLVMFunction originalSymbol = scope.getFunction(originalName);
        if (originalSymbol == null) {
            throw new LLVMLinkerException(String.format("The symbol %s could not be imported because the symbol %s was not found in library %s", external.getName(), originalName, lib));
        }
        LLVMFunction newFunction = LLVMFunction.create(name, originalSymbol.getFunction(), originalSymbol.getType(), parserResult.getRuntime().getBitcodeID(), external.getIndex(), external.isExported(), parserResult.getRuntime().getFile().getPath());
        LLVMScope fileScope = parserResult.getRuntime().getFileScope();
        fileScope.register(newFunction);
        it.remove();
        parserResult.getDefinedFunctions().add(external);
    }

    private static String getSimpleLibraryName(String name) {
        int index = name.indexOf(".");
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }

    private LLVMParserResult parseBinary(BinaryParserResult binaryParserResult, TruffleFile file) {
        ModelModule module = new ModelModule();
        Source source = binaryParserResult.getSource();
        LLVMScanner.parseBitcode(binaryParserResult.getBitcode(), module, source);
        TargetDataLayout layout = module.getTargetDataLayout();
        DataLayout targetDataLayout = new DataLayout(layout.getDataLayout());
        if (targetDataLayout.getByteOrder() != ByteOrder.LITTLE_ENDIAN) {
            throw new LLVMParserException("Byte order " + targetDataLayout.getByteOrder() + " of file " + source.getPath() + " is not supported");
        }
        NodeFactory nodeFactory = this.context.getLanguage().getActiveConfiguration().createNodeFactory(this.language, targetDataLayout);
        LLVMScope fileScope = new LLVMScope();
        int bitcodeID = this.nextFreeBitcodeID.getAndIncrement();
        LLVMParserRuntime runtime = new LLVMParserRuntime(fileScope, nodeFactory, bitcodeID, file, source.getName(), ParserDriver.getSourceFilesWithChecksums(this.context.getEnv(), module));
        LLVMParser parser = new LLVMParser(source, runtime);
        LLVMParserResult result = parser.parse(module, targetDataLayout);
        this.createDebugInfo(module, new LLVMSymbolReadResolver(runtime, new FrameDescriptor(), GetStackSpaceFactory.createAllocaFactory(), targetDataLayout, false));
        return result;
    }

    private static List<LLVMSourceFileReference> getSourceFilesWithChecksums(TruffleLanguage.Env env, ModelModule module) {
        List<LLVMSourceFileReference> sourceWithChecksum;
        if (SulongEngineOption.shouldVerifyCompileUnitChecksums(env) && !(sourceWithChecksum = module.getSourceFileReferences().stream().filter(f -> f.getChecksumKind() != LLVMSourceFileReference.ChecksumKind.CSK_None).collect(Collectors.toList())).isEmpty()) {
            return sourceWithChecksum;
        }
        return null;
    }

    private void createDebugInfo(ModelModule model, LLVMSymbolReadResolver symbolResolver) {
        LLVMSourceContext sourceContext = this.context.getSourceContext();
        model.getSourceGlobals().forEach((symbol, irValue) -> {
            LLVMExpressionNode node = symbolResolver.resolve((SymbolImpl)irValue);
            LLVMDebugObjectBuilder value = CommonNodeFactory.createDebugStaticValue(node, irValue instanceof GlobalVariable);
            sourceContext.registerStatic((LLVMSourceSymbol)symbol, value);
        });
        model.getSourceStaticMembers().forEach((type, symbol) -> {
            LLVMExpressionNode node = symbolResolver.resolve((SymbolImpl)symbol);
            LLVMDebugObjectBuilder value = CommonNodeFactory.createDebugStaticValue(node, symbol instanceof GlobalVariable);
            type.setValue(value);
        });
    }

    private LLVMParserResult parseLibraryWithSource(Source source, ByteSequence bytes) {
        BinaryParserResult binaryParserResult = BinaryParser.parse(bytes, source, this.context);
        if (binaryParserResult != null) {
            this.context.addLibraryPaths(binaryParserResult.getLibraryPaths());
            TruffleFile file = this.createTruffleFile(source.getName(), source.getPath(), binaryParserResult.getLocator(), "<source library>");
            this.processDependencies(source.getName(), file, binaryParserResult);
            return this.parseBinary(binaryParserResult, file);
        }
        LibraryLocator.traceDelegateNative(this.context, source);
        return null;
    }

    private TruffleFile createTruffleFile(String libName, String libPath, LibraryLocator locator, String reason) {
        TruffleFile file = locator.locate(this.context, libName, reason);
        if (file == null) {
            if (libPath != null) {
                file = this.context.getEnv().getInternalTruffleFile(libPath);
            } else {
                Path path = Paths.get(libName, new String[0]);
                LibraryLocator.traceDelegateNative(this.context, path);
                file = this.context.getEnv().getInternalTruffleFile(path.toUri());
            }
        }
        return file;
    }

    private void processDependencies(String libraryName, TruffleFile libFile, BinaryParserResult binaryParserResult) {
        for (String lib : this.context.preprocessDependencies(binaryParserResult.getLibraries(), libFile)) {
            if (libraryName.equals(lib)) continue;
            TruffleFile file = this.createTruffleFile(lib, null, binaryParserResult.getLocator(), "<dependency library>");
            CallTarget calls = this.language.getCachedLibrary(file.getPath());
            if (calls != null && !this.dependencies.contains(calls)) {
                this.dependencies.add(calls);
                continue;
            }
            Object sourceOrCallTarget = this.createDependencySource(lib, lib, true, file);
            if (sourceOrCallTarget == null || this.dependencies.contains(sourceOrCallTarget)) continue;
            this.dependencies.add(sourceOrCallTarget);
        }
    }

    private Object createDependencySource(String libName, String libPath, boolean isNative, TruffleFile file) {
        Source source;
        assert (file != null);
        if (!file.isRegularFile(new LinkOption[0])) {
            if (!isNative) {
                throw new LLVMParserException("'" + file.getName() + "' is not a file or does not exist.");
            }
            TruffleFile nativeFile = this.createNativeTruffleFile(libName, libPath);
            if (nativeFile == null) {
                return null;
            }
            return this.createNativeLibraryCallTarget(nativeFile);
        }
        if (this.language.containsLibrarySource(file.getPath())) {
            source = this.language.getLibrarySource(file.getPath());
        } else {
            try {
                source = Source.newBuilder((String)"llvm", (TruffleFile)file).internal(this.context.isInternalLibraryFile(file)).build();
                this.language.addLibrarySource(file.getPath(), source);
            }
            catch (IOException | OutOfMemoryError | SecurityException ex) {
                throw new LLVMParserException("Error reading file " + file.getName() + ".");
            }
        }
        return source;
    }

    private static void addExternalSymbolsToScopes(LLVMParserResult parserResult) {
        LLVMScope fileScope = parserResult.getRuntime().getFileScope();
        for (FunctionSymbol function : parserResult.getExternalFunctions()) {
            if (fileScope.contains(function.getName())) continue;
            fileScope.register(LLVMFunction.create(function.getName(), new LLVMFunctionCode.UnresolvedFunction(), function.getType(), parserResult.getRuntime().getBitcodeID(), function.getIndex(), false, parserResult.getRuntime().getFile().getPath()));
        }
        for (GlobalVariable global : parserResult.getExternalGlobals()) {
            if (fileScope.contains(global.getName())) continue;
            fileScope.register(LLVMGlobal.create(global.getName(), global.getType(), global.getSourceSymbol(), global.isReadOnly(), global.getIndex(), parserResult.getRuntime().getBitcodeID(), false));
        }
    }

    private CallTarget createLibraryCallTarget(String name, LLVMParserResult parserResult, Source source) {
        if (((Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.PARSE_ONLY)).booleanValue()) {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode((Object)0));
        }
        boolean lazyParsing = (Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.LAZY_PARSING);
        LoadModulesNode loadModules = LoadModulesNode.create(name, parserResult, lazyParsing, this.context.isInternalLibraryFile(parserResult.getRuntime().getFile()), this.dependencies, source, this.language);
        return Truffle.getRuntime().createCallTarget((RootNode)loadModules);
    }

    private CallTarget createNativeLibraryCallTarget(TruffleFile file) {
        if (((Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.PARSE_ONLY)).booleanValue()) {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode((Object)0));
        }
        LoadNativeNode loadNative = LoadNativeNode.create(new FrameDescriptor(), this.language, file);
        return Truffle.getRuntime().createCallTarget((RootNode)loadNative);
    }
}

