/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.netbeans.core.multitabs.TabDecorator;
import org.netbeans.core.multitabs.TabbedImpl;
import org.netbeans.core.multitabs.impl.TabTable;
import org.netbeans.core.windows.view.ui.tabcontrol.Utilities;
import org.netbeans.swing.tabcontrol.TabData;
import org.openide.awt.CloseButtonFactory;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class TabDataRenderer
implements TableCellRenderer {
    private static final Insets tabInsets = UIManager.getInsets("nb.multitabs.tabInsets");
    private static final int underlineHeight = UIManager.getInt("nb.multitabs.underlineHeight");
    private static final Color underlineColor = UIManager.getColor("nb.multitabs.underlineColor");
    private static final Color inactiveUnderlineColor = UIManager.getColor("nb.multitabs.inactiveUnderlineColor");
    private static final Color activeBackground = UIManager.getColor("nb.multitabs.activeBackground");
    private final RendererPanel renderer = new RendererPanel();
    private final List<TabDecorator> decorators = TabDataRenderer.getDecorators();
    private static final boolean SHOW_CLOSE_BUTTON = !Boolean.getBoolean("nb.tabs.suppressCloseButton");

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.renderer.clear();
        Rectangle rectangle = jTable.getCellRect(n, n2, true);
        this.renderer.setSize(rectangle.width, rectangle.height);
        if (object instanceof TabData) {
            boolean bl3;
            TabData tabData = (TabData)object;
            String string = tabData.getText();
            Icon icon = tabData.getIcon();
            Color color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
            Color color2 = bl ? jTable.getSelectionForeground() : jTable.getForeground();
            boolean bl4 = bl3 = activeBackground != null || underlineColor != null ? TabbedImpl.isActive(jTable) : false;
            if (!bl && bl3 && activeBackground != null) {
                color = activeBackground;
            }
            for (TabDecorator tabDecorator : this.decorators) {
                Icon icon2;
                String string2;
                Color color3 = tabDecorator.getBackground(tabData, bl);
                if (null != color3) {
                    color = color3;
                }
                if (null != (color3 = tabDecorator.getForeground(tabData, bl))) {
                    color2 = color3;
                }
                if (null != (string2 = tabDecorator.getText(tabData))) {
                    string = string2;
                }
                if (null == (icon2 = tabDecorator.getIcon(tabData))) continue;
                icon = icon2;
            }
            this.renderer.label.setText(string);
            this.renderer.label.setIcon(icon);
            this.renderer.label.setFont(jTable.getFont());
            this.renderer.setBackground(color);
            this.renderer.label.setForeground(color2);
            this.renderer.tabData = tabData;
            this.renderer.isSelected = bl;
            this.renderer.isActive = bl3;
            this.renderer.tabsLocation = jTable instanceof TabTable ? ((TabTable)jTable).getTabsLocation() : 1;
            if (jTable instanceof TabTable) {
                TabTable tabTable = (TabTable)jTable;
                if (TabDataRenderer.isClosable(tabData)) {
                    boolean bl5 = tabTable.isCloseButtonHighlighted(n, n2);
                    this.renderer.closeButton.setVisible(true);
                    this.renderer.closeButton.getModel().setRollover(bl5);
                    this.renderer.closeButton.getModel().setArmed(bl5);
                } else {
                    this.renderer.closeButton.setVisible(false);
                }
            }
        }
        return this.renderer;
    }

    boolean isInCloseButton(Rectangle rectangle, Point point) {
        return this.renderer.isInCloseButton(rectangle, point);
    }

    static boolean isClosable(TabData tabData) {
        if (!SHOW_CLOSE_BUTTON) {
            return false;
        }
        if (!Utilities.isEditorTopComponentClosingEnabled()) {
            return false;
        }
        Component component = tabData.getComponent();
        if (component instanceof TopComponent) {
            return !Boolean.TRUE.equals(((TopComponent)component).getClientProperty((Object)"netbeans.winsys.tc.closing_disabled"));
        }
        return true;
    }

    int getPreferredWidth(Object object) {
        int n = -1;
        this.renderer.clear();
        if (object instanceof TabData) {
            TabData tabData = (TabData)object;
            String string = tabData.getText();
            Icon icon = tabData.getIcon();
            for (TabDecorator tabDecorator : this.decorators) {
                Icon icon2;
                String string2 = tabDecorator.getText(tabData);
                if (null != string2) {
                    string = string2;
                }
                if (null == (icon2 = tabDecorator.getIcon(tabData))) continue;
                icon = icon2;
            }
            String string3 = "<html>";
            if (string.startsWith(string3) && string.indexOf(60, string3.length()) < 0 && string.indexOf(38, string3.length()) < 0) {
                string = string.substring(string3.length());
            }
            this.renderer.label.setText(string);
            this.renderer.label.setIcon(icon);
            this.renderer.tabData = tabData;
            n = this.renderer.getPreferredSize().width;
        }
        return n;
    }

    static int getPreferredTableRowHeight() {
        JLabel jLabel = new JLabel("ABC");
        int n = tabInsets != null ? TabDataRenderer.tabInsets.top + TabDataRenderer.tabInsets.bottom : 4;
        return n + Math.max(16, jLabel.getPreferredSize().height);
    }

    private static List<TabDecorator> getDecorators() {
        return new ArrayList<TabDecorator>(Lookup.getDefault().lookupAll(TabDecorator.class));
    }

    private class RendererPanel
    extends JPanel {
        private final JLabel label;
        private final JButton closeButton;
        private TabData tabData;
        private boolean isSelected;
        private boolean isActive;
        private int tabsLocation;

        public RendererPanel() {
            super(new BorderLayout(0, 0));
            this.tabsLocation = 1;
            if (tabInsets != null) {
                this.setBorder(new EmptyBorder(tabInsets));
            }
            this.label = new JLabel();
            this.label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 3));
            this.add((Component)this.label, "Center");
            this.closeButton = CloseButtonFactory.createCloseButton();
            this.add((Component)this.closeButton, "East");
        }

        void clear() {
            assert (EventQueue.isDispatchThread());
            this.label.setText(null);
            this.label.setIcon(null);
            this.setOpaque(true);
            this.tabData = null;
            this.isSelected = false;
            this.isActive = false;
            this.tabsLocation = 1;
            this.closeButton.getModel().setArmed(false);
            this.closeButton.getModel().setRollover(false);
            this.closeButton.setVisible(true);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            if (this.isSelected && underlineHeight > 0 && underlineColor != null) {
                graphics.setColor(this.isActive || inactiveUnderlineColor == null ? underlineColor : inactiveUnderlineColor);
                switch (this.tabsLocation) {
                    default: {
                        graphics.fillRect(0, rectangle.height - underlineHeight, rectangle.width, underlineHeight);
                        break;
                    }
                    case 3: {
                        graphics.fillRect(0, 0, rectangle.width, underlineHeight);
                        break;
                    }
                    case 2: {
                        graphics.fillRect(rectangle.width - underlineHeight, 0, underlineHeight, rectangle.height);
                        break;
                    }
                    case 4: {
                        graphics.fillRect(0, 0, underlineHeight, rectangle.height);
                    }
                }
            }
            for (TabDecorator tabDecorator : TabDataRenderer.this.decorators) {
                tabDecorator.paintAfter(this.tabData, graphics, rectangle, this.isSelected);
            }
        }

        private boolean isInCloseButton(Rectangle rectangle, Point point) {
            if (rectangle.contains(point) && this.closeButton.isVisible()) {
                Dimension dimension = this.closeButton.getPreferredSize();
                Rectangle rectangle2 = new Rectangle(dimension);
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width - 3;
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width - 3;
                rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
                return rectangle2.contains(point);
            }
            return false;
        }
    }
}

