/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.polyglot.FunctionProxyHandler;
import com.oracle.truffle.polyglot.HostAdapterFactory;
import com.oracle.truffle.polyglot.HostClassDesc;
import com.oracle.truffle.polyglot.HostExecuteNodeGen;
import com.oracle.truffle.polyglot.HostFieldDesc;
import com.oracle.truffle.polyglot.HostInteropErrors;
import com.oracle.truffle.polyglot.HostMethodDesc;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.ObjectProxyHandler;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import org.graalvm.collections.EconomicSet;

final class HostInteropReflect {
    static final Object[] EMPTY = new Object[0];
    static final String STATIC_TO_CLASS = "class";
    static final String CLASS_TO_STATIC = "static";
    static final String ADAPTER_SUPER_MEMBER = "super";
    static final String ADAPTER_DELEGATE_MEMBER = "this";

    private HostInteropReflect() {
    }

    @CompilerDirectives.TruffleBoundary
    static Class<?> findInnerClass(Class<?> clazz, String name) {
        if (!TruffleOptions.AOT && Modifier.isPublic(clazz.getModifiers())) {
            for (Class<?> t : clazz.getClasses()) {
                if (!HostInteropReflect.isStaticTypeOrInterface(t) || !t.getSimpleName().equals(name)) continue;
                return t;
            }
        }
        return null;
    }

    static boolean isSignature(String name) {
        return name.length() > 0 && name.charAt(name.length() - 1) == ')' && name.indexOf(40) != -1;
    }

    static boolean isJNIName(String name) {
        return name.contains("__");
    }

    @CompilerDirectives.TruffleBoundary
    static HostMethodDesc findMethod(PolyglotEngineImpl impl, Class<?> clazz, String name, boolean onlyStatic) {
        HostClassDesc classDesc = HostClassDesc.forClass(impl, clazz);
        HostMethodDesc foundMethod = classDesc.lookupMethod(name, onlyStatic);
        if (foundMethod == null && HostInteropReflect.isSignature(name)) {
            foundMethod = classDesc.lookupMethodBySignature(name, onlyStatic);
        }
        if (foundMethod == null && HostInteropReflect.isJNIName(name)) {
            foundMethod = classDesc.lookupMethodByJNIName(name, onlyStatic);
        }
        return foundMethod;
    }

    @CompilerDirectives.TruffleBoundary
    static HostFieldDesc findField(PolyglotEngineImpl impl, Class<?> clazz, String name, boolean onlyStatic) {
        HostClassDesc classDesc = HostClassDesc.forClass(impl, clazz);
        return classDesc.lookupField(name, onlyStatic);
    }

    @CompilerDirectives.TruffleBoundary
    static boolean isReadable(HostObject object, Class<?> clazz, String name, boolean onlyStatic, boolean isClass) {
        HostClassDesc classDesc = HostClassDesc.forClass(object.getEngine(), clazz);
        HostMethodDesc foundMethod = classDesc.lookupMethod(name, onlyStatic);
        if (foundMethod != null) {
            return true;
        }
        if (HostInteropReflect.isSignature(name) ? (foundMethod = classDesc.lookupMethodBySignature(name, onlyStatic)) != null : HostInteropReflect.isJNIName(name) && (foundMethod = classDesc.lookupMethodByJNIName(name, onlyStatic)) != null) {
            return true;
        }
        HostFieldDesc foundField = classDesc.lookupField(name, onlyStatic);
        if (foundField != null) {
            return true;
        }
        if (onlyStatic) {
            if (STATIC_TO_CLASS.equals(name)) {
                return true;
            }
            Class<?> innerClass = HostInteropReflect.findInnerClass(clazz, name);
            if (innerClass != null) {
                return true;
            }
        }
        return isClass && CLASS_TO_STATIC.equals(name);
    }

    @CompilerDirectives.TruffleBoundary
    static boolean isModifiable(HostObject object, Class<?> clazz, String name, boolean onlyStatic) {
        HostClassDesc classDesc = HostClassDesc.forClass(object.getEngine(), clazz);
        HostFieldDesc foundField = classDesc.lookupField(name, onlyStatic);
        return foundField != null && !foundField.isFinal();
    }

    @CompilerDirectives.TruffleBoundary
    static boolean isInvokable(HostObject object, Class<?> clazz, String name, boolean onlyStatic) {
        HostClassDesc classDesc = HostClassDesc.forClass(object.getEngine(), clazz);
        HostMethodDesc foundMethod = classDesc.lookupMethod(name, onlyStatic);
        if (foundMethod != null) {
            return true;
        }
        return HostInteropReflect.isSignature(name) ? (foundMethod = classDesc.lookupMethodBySignature(name, onlyStatic)) != null : HostInteropReflect.isJNIName(name) && (foundMethod = classDesc.lookupMethodByJNIName(name, onlyStatic)) != null;
    }

    @CompilerDirectives.TruffleBoundary
    static boolean isInternal(HostObject object, Class<?> clazz, String name, boolean onlyStatic) {
        HostClassDesc classDesc = HostClassDesc.forClass(object.getEngine(), clazz);
        HostMethodDesc foundMethod = classDesc.lookupMethod(name, onlyStatic);
        if (foundMethod != null) {
            return false;
        }
        return HostInteropReflect.isSignature(name) ? (foundMethod = classDesc.lookupMethodBySignature(name, onlyStatic)) != null : HostInteropReflect.isJNIName(name) && (foundMethod = classDesc.lookupMethodByJNIName(name, onlyStatic)) != null;
    }

    @CompilerDirectives.TruffleBoundary
    static <T> T asJavaFunction(Class<T> functionalType, Object function, PolyglotLanguageContext languageContext) {
        assert (HostInteropReflect.isFunctionalInterface(functionalType));
        Method functionalInterfaceMethod = HostInteropReflect.functionalInterfaceMethod(functionalType);
        FunctionProxyHandler handler = new FunctionProxyHandler(function, functionalInterfaceMethod, languageContext);
        Object obj = Proxy.newProxyInstance(functionalType.getClassLoader(), new Class[]{functionalType}, (InvocationHandler)handler);
        return functionalType.cast(obj);
    }

    @CompilerDirectives.TruffleBoundary
    static boolean isFunctionalInterface(Class<?> type) {
        if (!type.isInterface() || type == TruffleObject.class) {
            return false;
        }
        if (type.getAnnotation(FunctionalInterface.class) != null) {
            return true;
        }
        return HostInteropReflect.functionalInterfaceMethod(type) != null;
    }

    static Method functionalInterfaceMethod(Class<?> functionalInterface) {
        if (!functionalInterface.isInterface()) {
            return null;
        }
        Method found = null;
        for (Method m : functionalInterface.getMethods()) {
            if (!Modifier.isAbstract(m.getModifiers()) || HostClassDesc.isObjectMethodOverride(m)) continue;
            if (found != null) {
                return null;
            }
            found = m;
        }
        return found;
    }

    static Object asTruffleViaReflection(Object obj, PolyglotLanguageContext languageContext) {
        if (obj instanceof Proxy) {
            return HostInteropReflect.asTruffleObjectProxy(obj, languageContext);
        }
        return HostObject.forObject(obj, languageContext);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object asTruffleObjectProxy(Object obj, PolyglotLanguageContext languageContext) {
        if (Proxy.isProxyClass(obj.getClass())) {
            InvocationHandler h = Proxy.getInvocationHandler(obj);
            if (h instanceof FunctionProxyHandler) {
                return ((FunctionProxyHandler)h).functionObj;
            }
            if (h instanceof ObjectProxyHandler) {
                return ((ObjectProxyHandler)h).obj;
            }
        }
        return HostObject.forObject(obj, languageContext);
    }

    @CompilerDirectives.TruffleBoundary
    static Object newProxyInstance(Class<?> clazz, Object obj, PolyglotLanguageContext languageContext) throws IllegalArgumentException {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ObjectProxyHandler(obj, languageContext, clazz));
    }

    @CompilerDirectives.TruffleBoundary
    static Object newAdapterInstance(Class<?> clazz, Object obj, PolyglotLanguageContext languageContext) throws IllegalArgumentException {
        if (TruffleOptions.AOT) {
            throw PolyglotEngineException.unsupported("Unsupported target type.");
        }
        HostClassDesc classDesc = HostClassDesc.forClass(languageContext.getEngine(), clazz);
        HostAdapterFactory.AdapterResult adapter = classDesc.getAdapter(languageContext.context.getHostContextImpl());
        if (!adapter.isAutoConvertible()) {
            throw PolyglotEngineException.illegalArgument("Cannot convert to " + clazz);
        }
        HostMethodDesc.SingleMethod adapterConstructor = adapter.getValueConstructor();
        Object[] arguments = new Object[]{obj};
        try {
            return ((HostObject)HostExecuteNodeGen.getUncached().execute((HostMethodDesc)adapterConstructor, null, (Object[])arguments, (PolyglotLanguageContext)languageContext)).obj;
        }
        catch (UnsupportedTypeException e) {
            throw HostInteropErrors.invalidExecuteArgumentType(languageContext, null, e.getSuppliedValues());
        }
        catch (ArityException e) {
            throw HostInteropErrors.invalidExecuteArity(languageContext, null, arguments, e.getExpectedArity(), e.getActualArity());
        }
    }

    static boolean isStaticTypeOrInterface(Class<?> t) {
        return Modifier.isPublic(t.getModifiers()) && (t.isInterface() || t.isEnum() || Modifier.isStatic(t.getModifiers()));
    }

    static boolean isAbstractType(Class<?> targetType) {
        return targetType.isInterface() || !TruffleOptions.AOT && Modifier.isAbstract(targetType.getModifiers()) && !targetType.isArray() && !targetType.isPrimitive() && !Number.class.isAssignableFrom(targetType);
    }

    static boolean isExtensibleType(Class<?> targetType) {
        return targetType.isInterface() || !TruffleOptions.AOT && !Modifier.isFinal(targetType.getModifiers()) && !targetType.isArray() && !targetType.isPrimitive() && !Number.class.isAssignableFrom(targetType);
    }

    @CompilerDirectives.TruffleBoundary
    static String[] findUniquePublicMemberNames(PolyglotEngineImpl engine, Class<?> clazz, boolean isStatic, boolean isClass, boolean includeInternal) throws SecurityException {
        HostClassDesc classDesc = HostClassDesc.forClass(engine, clazz);
        EconomicSet names = EconomicSet.create();
        names.addAll(classDesc.getFieldNames(isStatic));
        names.addAll(classDesc.getMethodNames(isStatic, includeInternal));
        if (isStatic) {
            names.add((Object)STATIC_TO_CLASS);
            if (!TruffleOptions.AOT && Modifier.isPublic(clazz.getModifiers())) {
                for (Class<?> t : clazz.getClasses()) {
                    if (!HostInteropReflect.isStaticTypeOrInterface(t)) continue;
                    names.add((Object)t.getSimpleName());
                }
            }
        } else if (isClass) {
            names.add((Object)CLASS_TO_STATIC);
        }
        return (String[])names.toArray((Object[])new String[names.size()]);
    }

    static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    public static Class<?> getMethodReturnType(Method method) {
        if (method == null || method.getReturnType() == Void.TYPE) {
            return Object.class;
        }
        return method.getReturnType();
    }

    public static Type getMethodGenericReturnType(Method method) {
        if (method == null || method.getReturnType() == Void.TYPE) {
            return Object.class;
        }
        return method.getGenericReturnType();
    }

    static String toNameAndSignature(Method m) {
        StringBuilder sb = new StringBuilder();
        sb.append(m.getName());
        sb.append('(');
        Class<?>[] arr = m.getParameterTypes();
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(arr[i].getTypeName());
        }
        sb.append(')');
        return sb.toString();
    }

    static String jniName(Method m) {
        StringBuilder sb = new StringBuilder();
        HostInteropReflect.noUnderscore(sb, m.getName()).append("__");
        HostInteropReflect.appendType(sb, m.getReturnType());
        Class<?>[] arr = m.getParameterTypes();
        for (int i = 0; i < arr.length; ++i) {
            HostInteropReflect.appendType(sb, arr[i]);
        }
        return sb.toString();
    }

    private static StringBuilder noUnderscore(StringBuilder sb, String name) {
        return sb.append(name.replace("_", "_1").replace('.', '_'));
    }

    private static void appendType(StringBuilder sb, Class<?> type) {
        if (type == Integer.TYPE) {
            sb.append('I');
            return;
        }
        if (type == Long.TYPE) {
            sb.append('J');
            return;
        }
        if (type == Double.TYPE) {
            sb.append('D');
            return;
        }
        if (type == Float.TYPE) {
            sb.append('F');
            return;
        }
        if (type == Byte.TYPE) {
            sb.append('B');
            return;
        }
        if (type == Boolean.TYPE) {
            sb.append('Z');
            return;
        }
        if (type == Short.TYPE) {
            sb.append('S');
            return;
        }
        if (type == Void.TYPE) {
            sb.append('V');
            return;
        }
        if (type == Character.TYPE) {
            sb.append('C');
            return;
        }
        if (type.isArray()) {
            sb.append("_3");
            HostInteropReflect.appendType(sb, type.getComponentType());
            return;
        }
        HostInteropReflect.noUnderscore(sb.append('L'), type.getName());
        sb.append("_2");
    }
}

