/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.LanguageAccessor;
import com.oracle.truffle.api.nodes.Node;
import java.util.Objects;

@Deprecated
public final class Scope {
    private static final Scope EMPTY = new Scope();
    private final String name;
    private final Node node;
    private final Object arguments;
    private final Object variables;
    private final Object receiver;
    private final String receiverName;
    private final Object rootInstance;

    private Scope() {
        this.name = null;
        this.node = null;
        this.arguments = null;
        this.variables = null;
        this.receiver = null;
        this.receiverName = null;
        this.rootInstance = null;
    }

    Scope(String name, Node node, Object arguments, Object variables, Object receiver, String receiverName, Object rootInstance) {
        this.name = name;
        this.node = node;
        Scope.assertNullOrTruffleObject(arguments);
        this.arguments = arguments;
        Scope.assertTruffleObject(variables);
        this.variables = variables;
        Scope.assertNullOrInteropType(receiver);
        this.receiver = receiver;
        this.receiverName = receiverName;
        Scope.assertNullOrInteropType(rootInstance);
        this.rootInstance = rootInstance;
    }

    private static boolean assertTruffleObject(Object obj) {
        assert (LanguageAccessor.interopAccess().isTruffleObject(obj)) : Objects.toString(obj);
        return true;
    }

    private static void assertNullOrTruffleObject(Object obj) {
        assert (obj == null || Scope.assertTruffleObject(obj));
    }

    private static void assertNullOrInteropType(Object obj) {
        if (obj != null) {
            LanguageAccessor.interopAccess().checkInteropType(obj);
        }
    }

    private static void assertNullOrExecutable(Object obj) {
        if (obj != null) assert (LanguageAccessor.interopAccess().isExecutableObject(obj)) : Objects.toString(obj);
    }

    public static Builder newBuilder(String name, Object variables) {
        Scope scope = EMPTY;
        Objects.requireNonNull(scope);
        return scope.new Builder(name, variables);
    }

    public String getName() {
        return this.name;
    }

    public Node getNode() {
        return this.node;
    }

    public Object getVariables() {
        return this.variables;
    }

    public Object getArguments() {
        return this.arguments;
    }

    public Object getReceiver() {
        return this.receiver;
    }

    public Object getRootInstance() {
        return this.rootInstance;
    }

    public String getReceiverName() {
        return this.receiverName;
    }

    @Deprecated
    public final class Builder {
        private final String name;
        private Node node;
        private Object arguments;
        private final Object variables;
        private Object receiver;
        private String receiverName;
        private Object rootInstance;

        Builder(String name, Object variables) {
            assert (name != null);
            Scope.assertTruffleObject(variables);
            this.name = name;
            this.variables = variables;
        }

        public Builder node(Node node) {
            this.node = node;
            return this;
        }

        public Builder arguments(Object arguments) {
            Scope.assertNullOrTruffleObject(arguments);
            this.arguments = arguments;
            return this;
        }

        public Builder receiver(String name, Object receiver) {
            Scope.assertNullOrInteropType(receiver);
            this.receiverName = name;
            this.receiver = receiver;
            return this;
        }

        public Builder rootInstance(Object rootInstance) {
            Scope.assertNullOrInteropType(rootInstance);
            Scope.assertNullOrExecutable(rootInstance);
            this.rootInstance = rootInstance;
            return this;
        }

        public Scope build() {
            return new Scope(this.name, this.node, this.arguments, this.variables, this.receiver, this.receiverName, this.rootInstance);
        }
    }
}

