/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class TextDocumentItem
extends JSONBase {
    TextDocumentItem(JSONObject jsonData) {
        super(jsonData);
    }

    public String getUri() {
        return this.jsonData.getString("uri");
    }

    public TextDocumentItem setUri(String uri) {
        this.jsonData.put("uri", uri);
        return this;
    }

    public String getLanguageId() {
        return this.jsonData.getString("languageId");
    }

    public TextDocumentItem setLanguageId(String languageId) {
        this.jsonData.put("languageId", languageId);
        return this;
    }

    public int getVersion() {
        return this.jsonData.getInt("version");
    }

    public TextDocumentItem setVersion(int version) {
        this.jsonData.put("version", version);
        return this;
    }

    public String getText() {
        return this.jsonData.getString("text");
    }

    public TextDocumentItem setText(String text) {
        this.jsonData.put("text", text);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextDocumentItem other = (TextDocumentItem)obj;
        if (!Objects.equals(this.getUri(), other.getUri())) {
            return false;
        }
        if (!Objects.equals(this.getLanguageId(), other.getLanguageId())) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        return Objects.equals(this.getText(), other.getText());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.getUri());
        hash = 97 * hash + Objects.hashCode(this.getLanguageId());
        hash = 97 * hash + Integer.hashCode(this.getVersion());
        hash = 97 * hash + Objects.hashCode(this.getText());
        return hash;
    }

    public static TextDocumentItem create(String uri, String languageId, int version, String text) {
        JSONObject json = new JSONObject();
        json.put("uri", uri);
        json.put("languageId", languageId);
        json.put("version", version);
        json.put("text", text);
        return new TextDocumentItem(json);
    }
}

