/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import java.util.HashMap;
import java.util.Map;

public enum SymbolKind {
    File(1),
    Module(2),
    Namespace(3),
    Package(4),
    Class(5),
    Method(6),
    Property(7),
    Field(8),
    Constructor(9),
    Enum(10),
    Interface(11),
    Function(12),
    Variable(13),
    Constant(14),
    String(15),
    Number(16),
    Boolean(17),
    Array(18),
    Object(19),
    Key(20),
    Null(21),
    EnumMember(22),
    Struct(23),
    Event(24),
    Operator(25),
    TypeParameter(26);

    private final int intValue;
    private static final Map<Integer, SymbolKind> lookup;

    private SymbolKind(int intValue) {
        this.intValue = intValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public static SymbolKind get(Integer intValue) {
        return lookup.get(intValue);
    }

    static {
        lookup = new HashMap<Integer, SymbolKind>();
        for (SymbolKind value : SymbolKind.values()) {
            lookup.put(value.getIntValue(), value);
        }
    }
}

