/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.Position;
import org.graalvm.tools.lsp.server.types.SignatureHelpContext;
import org.graalvm.tools.lsp.server.types.TextDocumentIdentifier;
import org.graalvm.tools.lsp.server.types.TextDocumentPositionParams;

public class SignatureHelpParams
extends TextDocumentPositionParams {
    SignatureHelpParams(JSONObject jsonData) {
        super(jsonData);
    }

    public SignatureHelpContext getContext() {
        return this.jsonData.has("context") ? new SignatureHelpContext(this.jsonData.optJSONObject("context")) : null;
    }

    public SignatureHelpParams setContext(SignatureHelpContext context) {
        this.jsonData.putOpt("context", context != null ? context.jsonData : null);
        return this;
    }

    public Object getWorkDoneToken() {
        return this.jsonData.opt("workDoneToken");
    }

    public SignatureHelpParams setWorkDoneToken(Object workDoneToken) {
        this.jsonData.putOpt("workDoneToken", workDoneToken);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignatureHelpParams other = (SignatureHelpParams)obj;
        if (!Objects.equals(this.getContext(), other.getContext())) {
            return false;
        }
        if (!Objects.equals(this.getWorkDoneToken(), other.getWorkDoneToken())) {
            return false;
        }
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        return Objects.equals(this.getPosition(), other.getPosition());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        if (this.getContext() != null) {
            hash = 89 * hash + Objects.hashCode(this.getContext());
        }
        if (this.getWorkDoneToken() != null) {
            hash = 89 * hash + Objects.hashCode(this.getWorkDoneToken());
        }
        hash = 89 * hash + Objects.hashCode(this.getTextDocument());
        hash = 89 * hash + Objects.hashCode(this.getPosition());
        return hash;
    }

    public static SignatureHelpParams create(TextDocumentIdentifier textDocument, Position position) {
        JSONObject json = new JSONObject();
        json.put("textDocument", textDocument.jsonData);
        json.put("position", position.jsonData);
        return new SignatureHelpParams(json);
    }
}

