/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.Message;

public class RequestMessage
extends Message {
    RequestMessage(JSONObject jsonData) {
        super(jsonData);
    }

    public Object getId() {
        return this.jsonData.get("id");
    }

    public RequestMessage setId(Object id) {
        this.jsonData.put("id", id);
        return this;
    }

    public String getMethod() {
        return this.jsonData.getString("method");
    }

    public RequestMessage setMethod(String method) {
        this.jsonData.put("method", method);
        return this;
    }

    public Object getParams() {
        return this.jsonData.opt("params");
    }

    public RequestMessage setParams(Object params) {
        this.jsonData.putOpt("params", params);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestMessage other = (RequestMessage)obj;
        if (!Objects.equals(this.getId(), other.getId())) {
            return false;
        }
        if (!Objects.equals(this.getMethod(), other.getMethod())) {
            return false;
        }
        if (!Objects.equals(this.getParams(), other.getParams())) {
            return false;
        }
        return Objects.equals(this.getJsonrpc(), other.getJsonrpc());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.getId());
        hash = 79 * hash + Objects.hashCode(this.getMethod());
        if (this.getParams() != null) {
            hash = 79 * hash + Objects.hashCode(this.getParams());
        }
        hash = 79 * hash + Objects.hashCode(this.getJsonrpc());
        return hash;
    }

    public static RequestMessage create(Object id, String method, String jsonrpc) {
        JSONObject json = new JSONObject();
        json.put("id", id);
        json.put("method", method);
        json.put("jsonrpc", jsonrpc);
        return new RequestMessage(json);
    }
}

