/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.Registration;

public class RegistrationParams
extends JSONBase {
    RegistrationParams(JSONObject jsonData) {
        super(jsonData);
    }

    public List<Registration> getRegistrations() {
        JSONArray json = this.jsonData.getJSONArray("registrations");
        ArrayList<Registration> list = new ArrayList<Registration>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new Registration(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public RegistrationParams setRegistrations(List<Registration> registrations) {
        JSONArray json = new JSONArray();
        for (Registration registration : registrations) {
            json.put(registration.jsonData);
        }
        this.jsonData.put("registrations", json);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegistrationParams other = (RegistrationParams)obj;
        return Objects.equals(this.getRegistrations(), other.getRegistrations());
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.getRegistrations());
        return hash;
    }

    public static RegistrationParams create(List<Registration> registrations) {
        JSONObject json = new JSONObject();
        JSONArray registrationsJsonArr = new JSONArray();
        for (Registration registration : registrations) {
            registrationsJsonArr.put(registration.jsonData);
        }
        json.put("registrations", registrationsJsonArr);
        return new RegistrationParams(json);
    }
}

