/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.Diagnostic;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class PublishDiagnosticsParams
extends JSONBase {
    PublishDiagnosticsParams(JSONObject jsonData) {
        super(jsonData);
    }

    public String getUri() {
        return this.jsonData.getString("uri");
    }

    public PublishDiagnosticsParams setUri(String uri) {
        this.jsonData.put("uri", uri);
        return this;
    }

    public Integer getVersion() {
        return this.jsonData.has("version") ? Integer.valueOf(this.jsonData.getInt("version")) : null;
    }

    public PublishDiagnosticsParams setVersion(Integer version) {
        this.jsonData.putOpt("version", version);
        return this;
    }

    public List<Diagnostic> getDiagnostics() {
        JSONArray json = this.jsonData.getJSONArray("diagnostics");
        ArrayList<Diagnostic> list = new ArrayList<Diagnostic>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new Diagnostic(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public PublishDiagnosticsParams setDiagnostics(List<Diagnostic> diagnostics) {
        JSONArray json = new JSONArray();
        for (Diagnostic diagnostic : diagnostics) {
            json.put(diagnostic.jsonData);
        }
        this.jsonData.put("diagnostics", json);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublishDiagnosticsParams other = (PublishDiagnosticsParams)obj;
        if (!Objects.equals(this.getUri(), other.getUri())) {
            return false;
        }
        if (!Objects.equals(this.getVersion(), other.getVersion())) {
            return false;
        }
        return Objects.equals(this.getDiagnostics(), other.getDiagnostics());
    }

    public int hashCode() {
        int hash = 2;
        hash = 53 * hash + Objects.hashCode(this.getUri());
        if (this.getVersion() != null) {
            hash = 53 * hash + Integer.hashCode(this.getVersion());
        }
        hash = 53 * hash + Objects.hashCode(this.getDiagnostics());
        return hash;
    }

    public static PublishDiagnosticsParams create(String uri, List<Diagnostic> diagnostics) {
        JSONObject json = new JSONObject();
        json.put("uri", uri);
        JSONArray diagnosticsJsonArr = new JSONArray();
        for (Diagnostic diagnostic : diagnostics) {
            diagnosticsJsonArr.put(diagnostic.jsonData);
        }
        json.put("diagnostics", diagnosticsJsonArr);
        return new PublishDiagnosticsParams(json);
    }
}

