/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.DiagnosticTag;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;

public class PublishDiagnosticsClientCapabilities
extends JSONBase {
    PublishDiagnosticsClientCapabilities(JSONObject jsonData) {
        super(jsonData);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getRelatedInformation() {
        return this.jsonData.has("relatedInformation") ? Boolean.valueOf(this.jsonData.getBoolean("relatedInformation")) : null;
    }

    public PublishDiagnosticsClientCapabilities setRelatedInformation(Boolean relatedInformation) {
        this.jsonData.putOpt("relatedInformation", relatedInformation);
        return this;
    }

    public TagSupportCapabilities getTagSupport() {
        return this.jsonData.has("tagSupport") ? new TagSupportCapabilities(this.jsonData.optJSONObject("tagSupport")) : null;
    }

    public PublishDiagnosticsClientCapabilities setTagSupport(TagSupportCapabilities tagSupport) {
        this.jsonData.putOpt("tagSupport", tagSupport != null ? tagSupport.jsonData : null);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getVersionSupport() {
        return this.jsonData.has("versionSupport") ? Boolean.valueOf(this.jsonData.getBoolean("versionSupport")) : null;
    }

    public PublishDiagnosticsClientCapabilities setVersionSupport(Boolean versionSupport) {
        this.jsonData.putOpt("versionSupport", versionSupport);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublishDiagnosticsClientCapabilities other = (PublishDiagnosticsClientCapabilities)obj;
        if (!Objects.equals(this.getRelatedInformation(), other.getRelatedInformation())) {
            return false;
        }
        if (!Objects.equals(this.getTagSupport(), other.getTagSupport())) {
            return false;
        }
        return Objects.equals(this.getVersionSupport(), other.getVersionSupport());
    }

    public int hashCode() {
        int hash = 2;
        if (this.getRelatedInformation() != null) {
            hash = 29 * hash + Boolean.hashCode(this.getRelatedInformation());
        }
        if (this.getTagSupport() != null) {
            hash = 29 * hash + Objects.hashCode(this.getTagSupport());
        }
        if (this.getVersionSupport() != null) {
            hash = 29 * hash + Boolean.hashCode(this.getVersionSupport());
        }
        return hash;
    }

    public static PublishDiagnosticsClientCapabilities create() {
        JSONObject json = new JSONObject();
        return new PublishDiagnosticsClientCapabilities(json);
    }

    public static class TagSupportCapabilities
    extends JSONBase {
        TagSupportCapabilities(JSONObject jsonData) {
            super(jsonData);
        }

        public List<DiagnosticTag> getValueSet() {
            JSONArray json = this.jsonData.getJSONArray("valueSet");
            ArrayList<DiagnosticTag> list = new ArrayList<DiagnosticTag>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(DiagnosticTag.get(json.getInt(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public TagSupportCapabilities setValueSet(List<DiagnosticTag> valueSet) {
            JSONArray json = new JSONArray();
            for (DiagnosticTag diagnosticTag : valueSet) {
                json.put(diagnosticTag.getIntValue());
            }
            this.jsonData.put("valueSet", json);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TagSupportCapabilities other = (TagSupportCapabilities)obj;
            return Objects.equals(this.getValueSet(), other.getValueSet());
        }

        public int hashCode() {
            int hash = 7;
            hash = 73 * hash + Objects.hashCode(this.getValueSet());
            return hash;
        }
    }
}

