/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class Position
extends JSONBase {
    Position(JSONObject jsonData) {
        super(jsonData);
    }

    public int getLine() {
        return this.jsonData.getInt("line");
    }

    public Position setLine(int line) {
        this.jsonData.put("line", line);
        return this;
    }

    public int getCharacter() {
        return this.jsonData.getInt("character");
    }

    public Position setCharacter(int character) {
        this.jsonData.put("character", character);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        if (this.getLine() != other.getLine()) {
            return false;
        }
        return this.getCharacter() == other.getCharacter();
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Integer.hashCode(this.getLine());
        hash = 89 * hash + Integer.hashCode(this.getCharacter());
        return hash;
    }

    public static Position create(int line, int character) {
        JSONObject json = new JSONObject();
        json.put("line", line);
        json.put("character", character);
        return new Position(json);
    }
}

