/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.ServerCapabilities;

public class InitializeResult
extends JSONBase {
    InitializeResult(JSONObject jsonData) {
        super(jsonData);
    }

    public ServerCapabilities getCapabilities() {
        return new ServerCapabilities(this.jsonData.getJSONObject("capabilities"));
    }

    public InitializeResult setCapabilities(ServerCapabilities capabilities) {
        this.jsonData.put("capabilities", capabilities.jsonData);
        return this;
    }

    public ServerInfoResult getServerInfo() {
        return this.jsonData.has("serverInfo") ? new ServerInfoResult(this.jsonData.optJSONObject("serverInfo")) : null;
    }

    public InitializeResult setServerInfo(ServerInfoResult serverInfo) {
        this.jsonData.putOpt("serverInfo", serverInfo != null ? serverInfo.jsonData : null);
        return this;
    }

    public Object get(String key) {
        return this.jsonData.get(key);
    }

    public InitializeResult set(String key, Object value) {
        this.jsonData.put(key, value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitializeResult other = (InitializeResult)obj;
        if (!Objects.equals(this.getCapabilities(), other.getCapabilities())) {
            return false;
        }
        return Objects.equals(this.getServerInfo(), other.getServerInfo());
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.getCapabilities());
        if (this.getServerInfo() != null) {
            hash = 41 * hash + Objects.hashCode(this.getServerInfo());
        }
        return hash;
    }

    public static InitializeResult create(ServerCapabilities capabilities) {
        JSONObject json = new JSONObject();
        json.put("capabilities", capabilities.jsonData);
        return new InitializeResult(json);
    }

    public static class ServerInfoResult
    extends JSONBase {
        ServerInfoResult(JSONObject jsonData) {
            super(jsonData);
        }

        public String getName() {
            return this.jsonData.getString("name");
        }

        public ServerInfoResult setName(String name) {
            this.jsonData.put("name", name);
            return this;
        }

        public String getVersion() {
            return this.jsonData.optString("version", null);
        }

        public ServerInfoResult setVersion(String version) {
            this.jsonData.putOpt("version", version);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServerInfoResult other = (ServerInfoResult)obj;
            if (!Objects.equals(this.getName(), other.getName())) {
                return false;
            }
            return Objects.equals(this.getVersion(), other.getVersion());
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + Objects.hashCode(this.getName());
            if (this.getVersion() != null) {
                hash = 37 * hash + Objects.hashCode(this.getVersion());
            }
            return hash;
        }
    }
}

