/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.FileEvent;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class DidChangeWatchedFilesParams
extends JSONBase {
    DidChangeWatchedFilesParams(JSONObject jsonData) {
        super(jsonData);
    }

    public List<FileEvent> getChanges() {
        JSONArray json = this.jsonData.getJSONArray("changes");
        ArrayList<FileEvent> list = new ArrayList<FileEvent>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new FileEvent(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public DidChangeWatchedFilesParams setChanges(List<FileEvent> changes) {
        JSONArray json = new JSONArray();
        for (FileEvent fileEvent : changes) {
            json.put(fileEvent.jsonData);
        }
        this.jsonData.put("changes", json);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DidChangeWatchedFilesParams other = (DidChangeWatchedFilesParams)obj;
        return Objects.equals(this.getChanges(), other.getChanges());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.getChanges());
        return hash;
    }

    public static DidChangeWatchedFilesParams create(List<FileEvent> changes) {
        JSONObject json = new JSONObject();
        JSONArray changesJsonArr = new JSONArray();
        for (FileEvent fileEvent : changes) {
            changesJsonArr.put(fileEvent.jsonData);
        }
        json.put("changes", changesJsonArr);
        return new DidChangeWatchedFilesParams(json);
    }
}

