/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;
import org.graalvm.tools.lsp.server.types.WorkDoneProgressOptions;

public class CompletionOptions
extends WorkDoneProgressOptions {
    CompletionOptions(JSONObject jsonData) {
        super(jsonData);
    }

    public List<String> getTriggerCharacters() {
        JSONArray json = this.jsonData.optJSONArray("triggerCharacters");
        if (json == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getString(i));
        }
        return Collections.unmodifiableList(list);
    }

    public CompletionOptions setTriggerCharacters(List<String> triggerCharacters) {
        if (triggerCharacters != null) {
            JSONArray json = new JSONArray();
            for (String string : triggerCharacters) {
                json.put(string);
            }
            this.jsonData.put("triggerCharacters", json);
        }
        return this;
    }

    public List<String> getAllCommitCharacters() {
        JSONArray json = this.jsonData.optJSONArray("allCommitCharacters");
        if (json == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getString(i));
        }
        return Collections.unmodifiableList(list);
    }

    public CompletionOptions setAllCommitCharacters(List<String> allCommitCharacters) {
        if (allCommitCharacters != null) {
            JSONArray json = new JSONArray();
            for (String string : allCommitCharacters) {
                json.put(string);
            }
            this.jsonData.put("allCommitCharacters", json);
        }
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getResolveProvider() {
        return this.jsonData.has("resolveProvider") ? Boolean.valueOf(this.jsonData.getBoolean("resolveProvider")) : null;
    }

    public CompletionOptions setResolveProvider(Boolean resolveProvider) {
        this.jsonData.putOpt("resolveProvider", resolveProvider);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompletionOptions other = (CompletionOptions)obj;
        if (!Objects.equals(this.getTriggerCharacters(), other.getTriggerCharacters())) {
            return false;
        }
        if (!Objects.equals(this.getAllCommitCharacters(), other.getAllCommitCharacters())) {
            return false;
        }
        if (!Objects.equals(this.getResolveProvider(), other.getResolveProvider())) {
            return false;
        }
        return Objects.equals(this.getWorkDoneProgress(), other.getWorkDoneProgress());
    }

    @Override
    public int hashCode() {
        int hash = 5;
        if (this.getTriggerCharacters() != null) {
            hash = 17 * hash + Objects.hashCode(this.getTriggerCharacters());
        }
        if (this.getAllCommitCharacters() != null) {
            hash = 17 * hash + Objects.hashCode(this.getAllCommitCharacters());
        }
        if (this.getResolveProvider() != null) {
            hash = 17 * hash + Boolean.hashCode(this.getResolveProvider());
        }
        if (this.getWorkDoneProgress() != null) {
            hash = 17 * hash + Boolean.hashCode(this.getWorkDoneProgress());
        }
        return hash;
    }

    public static CompletionOptions create() {
        JSONObject json = new JSONObject();
        return new CompletionOptions(json);
    }
}

