/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.Command;
import org.graalvm.tools.lsp.server.types.CompletionItemKind;
import org.graalvm.tools.lsp.server.types.CompletionItemTag;
import org.graalvm.tools.lsp.server.types.InsertTextFormat;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.MarkupContent;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;
import org.graalvm.tools.lsp.server.types.TextEdit;

public class CompletionItem
extends JSONBase {
    CompletionItem(JSONObject jsonData) {
        super(jsonData);
    }

    public String getLabel() {
        return this.jsonData.getString("label");
    }

    public CompletionItem setLabel(String label) {
        this.jsonData.put("label", label);
        return this;
    }

    public CompletionItemKind getKind() {
        return CompletionItemKind.get(this.jsonData.has("kind") ? Integer.valueOf(this.jsonData.getInt("kind")) : null);
    }

    public CompletionItem setKind(CompletionItemKind kind) {
        this.jsonData.putOpt("kind", kind != null ? Integer.valueOf(kind.getIntValue()) : null);
        return this;
    }

    public List<CompletionItemTag> getTags() {
        JSONArray json = this.jsonData.optJSONArray("tags");
        if (json == null) {
            return null;
        }
        ArrayList<CompletionItemTag> list = new ArrayList<CompletionItemTag>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(CompletionItemTag.get(json.getInt(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public CompletionItem setTags(List<CompletionItemTag> tags) {
        if (tags != null) {
            JSONArray json = new JSONArray();
            for (CompletionItemTag completionItemTag : tags) {
                json.put(completionItemTag.getIntValue());
            }
            this.jsonData.put("tags", json);
        }
        return this;
    }

    public String getDetail() {
        return this.jsonData.optString("detail", null);
    }

    public CompletionItem setDetail(String detail) {
        this.jsonData.putOpt("detail", detail);
        return this;
    }

    public Object getDocumentation() {
        Object obj = this.jsonData.opt("documentation");
        if (obj instanceof JSONObject) {
            return new MarkupContent((JSONObject)obj);
        }
        return obj;
    }

    public CompletionItem setDocumentation(Object documentation) {
        if (documentation instanceof MarkupContent) {
            this.jsonData.put("documentation", ((MarkupContent)documentation).jsonData);
        } else {
            this.jsonData.put("documentation", documentation);
        }
        return this;
    }

    @Deprecated
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getDeprecated() {
        return this.jsonData.has("deprecated") ? Boolean.valueOf(this.jsonData.getBoolean("deprecated")) : null;
    }

    public CompletionItem setDeprecated(Boolean deprecated) {
        this.jsonData.putOpt("deprecated", deprecated);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getPreselect() {
        return this.jsonData.has("preselect") ? Boolean.valueOf(this.jsonData.getBoolean("preselect")) : null;
    }

    public CompletionItem setPreselect(Boolean preselect) {
        this.jsonData.putOpt("preselect", preselect);
        return this;
    }

    public String getSortText() {
        return this.jsonData.optString("sortText", null);
    }

    public CompletionItem setSortText(String sortText) {
        this.jsonData.putOpt("sortText", sortText);
        return this;
    }

    public String getFilterText() {
        return this.jsonData.optString("filterText", null);
    }

    public CompletionItem setFilterText(String filterText) {
        this.jsonData.putOpt("filterText", filterText);
        return this;
    }

    public String getInsertText() {
        return this.jsonData.optString("insertText", null);
    }

    public CompletionItem setInsertText(String insertText) {
        this.jsonData.putOpt("insertText", insertText);
        return this;
    }

    public InsertTextFormat getInsertTextFormat() {
        return InsertTextFormat.get(this.jsonData.has("insertTextFormat") ? Integer.valueOf(this.jsonData.getInt("insertTextFormat")) : null);
    }

    public CompletionItem setInsertTextFormat(InsertTextFormat insertTextFormat) {
        this.jsonData.putOpt("insertTextFormat", insertTextFormat != null ? Integer.valueOf(insertTextFormat.getIntValue()) : null);
        return this;
    }

    public TextEdit getTextEdit() {
        return this.jsonData.has("textEdit") ? new TextEdit(this.jsonData.optJSONObject("textEdit")) : null;
    }

    public CompletionItem setTextEdit(TextEdit textEdit) {
        this.jsonData.putOpt("textEdit", textEdit != null ? textEdit.jsonData : null);
        return this;
    }

    public List<TextEdit> getAdditionalTextEdits() {
        JSONArray json = this.jsonData.optJSONArray("additionalTextEdits");
        if (json == null) {
            return null;
        }
        ArrayList<TextEdit> list = new ArrayList<TextEdit>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new TextEdit(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public CompletionItem setAdditionalTextEdits(List<TextEdit> additionalTextEdits) {
        if (additionalTextEdits != null) {
            JSONArray json = new JSONArray();
            for (TextEdit textEdit : additionalTextEdits) {
                json.put(textEdit.jsonData);
            }
            this.jsonData.put("additionalTextEdits", json);
        }
        return this;
    }

    public List<String> getCommitCharacters() {
        JSONArray json = this.jsonData.optJSONArray("commitCharacters");
        if (json == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getString(i));
        }
        return Collections.unmodifiableList(list);
    }

    public CompletionItem setCommitCharacters(List<String> commitCharacters) {
        if (commitCharacters != null) {
            JSONArray json = new JSONArray();
            for (String string : commitCharacters) {
                json.put(string);
            }
            this.jsonData.put("commitCharacters", json);
        }
        return this;
    }

    public Command getCommand() {
        return this.jsonData.has("command") ? new Command(this.jsonData.optJSONObject("command")) : null;
    }

    public CompletionItem setCommand(Command command) {
        this.jsonData.putOpt("command", command != null ? command.jsonData : null);
        return this;
    }

    public Object getData() {
        return this.jsonData.opt("data");
    }

    public CompletionItem setData(Object data) {
        this.jsonData.putOpt("data", data);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompletionItem other = (CompletionItem)obj;
        if (!Objects.equals(this.getLabel(), other.getLabel())) {
            return false;
        }
        if (this.getKind() != other.getKind()) {
            return false;
        }
        if (!Objects.equals(this.getTags(), other.getTags())) {
            return false;
        }
        if (!Objects.equals(this.getDetail(), other.getDetail())) {
            return false;
        }
        if (!Objects.equals(this.getDocumentation(), other.getDocumentation())) {
            return false;
        }
        if (!Objects.equals(this.getDeprecated(), other.getDeprecated())) {
            return false;
        }
        if (!Objects.equals(this.getPreselect(), other.getPreselect())) {
            return false;
        }
        if (!Objects.equals(this.getSortText(), other.getSortText())) {
            return false;
        }
        if (!Objects.equals(this.getFilterText(), other.getFilterText())) {
            return false;
        }
        if (!Objects.equals(this.getInsertText(), other.getInsertText())) {
            return false;
        }
        if (this.getInsertTextFormat() != other.getInsertTextFormat()) {
            return false;
        }
        if (!Objects.equals(this.getTextEdit(), other.getTextEdit())) {
            return false;
        }
        if (!Objects.equals(this.getAdditionalTextEdits(), other.getAdditionalTextEdits())) {
            return false;
        }
        if (!Objects.equals(this.getCommitCharacters(), other.getCommitCharacters())) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        return Objects.equals(this.getData(), other.getData());
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.getLabel());
        if (this.getKind() != null) {
            hash = 41 * hash + Objects.hashCode((Object)this.getKind());
        }
        if (this.getTags() != null) {
            hash = 41 * hash + Objects.hashCode(this.getTags());
        }
        if (this.getDetail() != null) {
            hash = 41 * hash + Objects.hashCode(this.getDetail());
        }
        if (this.getDocumentation() != null) {
            hash = 41 * hash + Objects.hashCode(this.getDocumentation());
        }
        if (this.getDeprecated() != null) {
            hash = 41 * hash + Boolean.hashCode(this.getDeprecated());
        }
        if (this.getPreselect() != null) {
            hash = 41 * hash + Boolean.hashCode(this.getPreselect());
        }
        if (this.getSortText() != null) {
            hash = 41 * hash + Objects.hashCode(this.getSortText());
        }
        if (this.getFilterText() != null) {
            hash = 41 * hash + Objects.hashCode(this.getFilterText());
        }
        if (this.getInsertText() != null) {
            hash = 41 * hash + Objects.hashCode(this.getInsertText());
        }
        if (this.getInsertTextFormat() != null) {
            hash = 41 * hash + Objects.hashCode((Object)this.getInsertTextFormat());
        }
        if (this.getTextEdit() != null) {
            hash = 41 * hash + Objects.hashCode(this.getTextEdit());
        }
        if (this.getAdditionalTextEdits() != null) {
            hash = 41 * hash + Objects.hashCode(this.getAdditionalTextEdits());
        }
        if (this.getCommitCharacters() != null) {
            hash = 41 * hash + Objects.hashCode(this.getCommitCharacters());
        }
        if (this.getCommand() != null) {
            hash = 41 * hash + Objects.hashCode(this.getCommand());
        }
        if (this.getData() != null) {
            hash = 41 * hash + Objects.hashCode(this.getData());
        }
        return hash;
    }

    public static CompletionItem create(String label) {
        JSONObject json = new JSONObject();
        json.put("label", label);
        return new CompletionItem(json);
    }
}

