/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import org.graalvm.tools.lsp.server.types.JSONBase;

public class Color
extends JSONBase {
    Color(JSONObject jsonData) {
        super(jsonData);
    }

    public double getRed() {
        return this.jsonData.getDouble("red");
    }

    public double getGreen() {
        return this.jsonData.getDouble("green");
    }

    public double getBlue() {
        return this.jsonData.getDouble("blue");
    }

    public double getAlpha() {
        return this.jsonData.getDouble("alpha");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Color other = (Color)obj;
        if (this.getRed() != other.getRed()) {
            return false;
        }
        if (this.getGreen() != other.getGreen()) {
            return false;
        }
        if (this.getBlue() != other.getBlue()) {
            return false;
        }
        return this.getAlpha() == other.getAlpha();
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Double.hashCode(this.getRed());
        hash = 23 * hash + Double.hashCode(this.getGreen());
        hash = 23 * hash + Double.hashCode(this.getBlue());
        hash = 23 * hash + Double.hashCode(this.getAlpha());
        return hash;
    }

    public static Color create(double red, double green, double blue, double alpha) {
        JSONObject json = new JSONObject();
        json.put("red", red);
        json.put("green", green);
        json.put("blue", blue);
        json.put("alpha", alpha);
        return new Color(json);
    }
}

