/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.CodeActionKind;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;

public class CodeActionClientCapabilities
extends JSONBase {
    CodeActionClientCapabilities(JSONObject jsonData) {
        super(jsonData);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getDynamicRegistration() {
        return this.jsonData.has("dynamicRegistration") ? Boolean.valueOf(this.jsonData.getBoolean("dynamicRegistration")) : null;
    }

    public CodeActionClientCapabilities setDynamicRegistration(Boolean dynamicRegistration) {
        this.jsonData.putOpt("dynamicRegistration", dynamicRegistration);
        return this;
    }

    public CodeActionLiteralSupportCapabilities getCodeActionLiteralSupport() {
        return this.jsonData.has("codeActionLiteralSupport") ? new CodeActionLiteralSupportCapabilities(this.jsonData.optJSONObject("codeActionLiteralSupport")) : null;
    }

    public CodeActionClientCapabilities setCodeActionLiteralSupport(CodeActionLiteralSupportCapabilities codeActionLiteralSupport) {
        this.jsonData.putOpt("codeActionLiteralSupport", codeActionLiteralSupport != null ? codeActionLiteralSupport.jsonData : null);
        return this;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getIsPreferredSupport() {
        return this.jsonData.has("isPreferredSupport") ? Boolean.valueOf(this.jsonData.getBoolean("isPreferredSupport")) : null;
    }

    public CodeActionClientCapabilities setIsPreferredSupport(Boolean isPreferredSupport) {
        this.jsonData.putOpt("isPreferredSupport", isPreferredSupport);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeActionClientCapabilities other = (CodeActionClientCapabilities)obj;
        if (!Objects.equals(this.getDynamicRegistration(), other.getDynamicRegistration())) {
            return false;
        }
        if (!Objects.equals(this.getCodeActionLiteralSupport(), other.getCodeActionLiteralSupport())) {
            return false;
        }
        return Objects.equals(this.getIsPreferredSupport(), other.getIsPreferredSupport());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getDynamicRegistration() != null) {
            hash = 79 * hash + Boolean.hashCode(this.getDynamicRegistration());
        }
        if (this.getCodeActionLiteralSupport() != null) {
            hash = 79 * hash + Objects.hashCode(this.getCodeActionLiteralSupport());
        }
        if (this.getIsPreferredSupport() != null) {
            hash = 79 * hash + Boolean.hashCode(this.getIsPreferredSupport());
        }
        return hash;
    }

    public static CodeActionClientCapabilities create() {
        JSONObject json = new JSONObject();
        return new CodeActionClientCapabilities(json);
    }

    public static class CodeActionLiteralSupportCapabilities
    extends JSONBase {
        CodeActionLiteralSupportCapabilities(JSONObject jsonData) {
            super(jsonData);
        }

        public CodeActionKindCapabilities getCodeActionKind() {
            return new CodeActionKindCapabilities(this.jsonData.getJSONObject("codeActionKind"));
        }

        public CodeActionLiteralSupportCapabilities setCodeActionKind(CodeActionKindCapabilities codeActionKind) {
            this.jsonData.put("codeActionKind", codeActionKind.jsonData);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CodeActionLiteralSupportCapabilities other = (CodeActionLiteralSupportCapabilities)obj;
            return Objects.equals(this.getCodeActionKind(), other.getCodeActionKind());
        }

        public int hashCode() {
            int hash = 3;
            hash = 29 * hash + Objects.hashCode(this.getCodeActionKind());
            return hash;
        }

        public static class CodeActionKindCapabilities
        extends JSONBase {
            CodeActionKindCapabilities(JSONObject jsonData) {
                super(jsonData);
            }

            public List<CodeActionKind> getValueSet() {
                JSONArray json = this.jsonData.getJSONArray("valueSet");
                ArrayList<CodeActionKind> list = new ArrayList<CodeActionKind>(json.length());
                for (int i = 0; i < json.length(); ++i) {
                    list.add(CodeActionKind.get(json.getString(i)));
                }
                return Collections.unmodifiableList(list);
            }

            public CodeActionKindCapabilities setValueSet(List<CodeActionKind> valueSet) {
                JSONArray json = new JSONArray();
                for (CodeActionKind codeActionKind : valueSet) {
                    json.put(codeActionKind.getStringValue());
                }
                this.jsonData.put("valueSet", json);
                return this;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                CodeActionKindCapabilities other = (CodeActionKindCapabilities)obj;
                return Objects.equals(this.getValueSet(), other.getValueSet());
            }

            public int hashCode() {
                int hash = 7;
                hash = 59 * hash + Objects.hashCode(this.getValueSet());
                return hash;
            }
        }
    }
}

