/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.server.types;

import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;
import org.graalvm.tools.lsp.server.types.JSONBase;
import org.graalvm.tools.lsp.server.types.SuppressFBWarnings;
import org.graalvm.tools.lsp.server.types.TextDocumentClientCapabilities;
import org.graalvm.tools.lsp.server.types.WorkspaceClientCapabilities;

public class ClientCapabilities
extends JSONBase {
    ClientCapabilities(JSONObject jsonData) {
        super(jsonData);
    }

    public WorkspaceClientCapabilities getWorkspace() {
        return this.jsonData.has("workspace") ? new WorkspaceClientCapabilities(this.jsonData.optJSONObject("workspace")) : null;
    }

    public ClientCapabilities setWorkspace(WorkspaceClientCapabilities workspace) {
        this.jsonData.putOpt("workspace", workspace != null ? workspace.jsonData : null);
        return this;
    }

    public TextDocumentClientCapabilities getTextDocument() {
        return this.jsonData.has("textDocument") ? new TextDocumentClientCapabilities(this.jsonData.optJSONObject("textDocument")) : null;
    }

    public ClientCapabilities setTextDocument(TextDocumentClientCapabilities textDocument) {
        this.jsonData.putOpt("textDocument", textDocument != null ? textDocument.jsonData : null);
        return this;
    }

    public WindowCapabilities getWindow() {
        return this.jsonData.has("window") ? new WindowCapabilities(this.jsonData.optJSONObject("window")) : null;
    }

    public ClientCapabilities setWindow(WindowCapabilities window) {
        this.jsonData.putOpt("window", window != null ? window.jsonData : null);
        return this;
    }

    public Object getExperimental() {
        return this.jsonData.opt("experimental");
    }

    public ClientCapabilities setExperimental(Object experimental) {
        this.jsonData.putOpt("experimental", experimental);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientCapabilities other = (ClientCapabilities)obj;
        if (!Objects.equals(this.getWorkspace(), other.getWorkspace())) {
            return false;
        }
        if (!Objects.equals(this.getTextDocument(), other.getTextDocument())) {
            return false;
        }
        if (!Objects.equals(this.getWindow(), other.getWindow())) {
            return false;
        }
        return Objects.equals(this.getExperimental(), other.getExperimental());
    }

    public int hashCode() {
        int hash = 2;
        if (this.getWorkspace() != null) {
            hash = 53 * hash + Objects.hashCode(this.getWorkspace());
        }
        if (this.getTextDocument() != null) {
            hash = 53 * hash + Objects.hashCode(this.getTextDocument());
        }
        if (this.getWindow() != null) {
            hash = 53 * hash + Objects.hashCode(this.getWindow());
        }
        if (this.getExperimental() != null) {
            hash = 53 * hash + Objects.hashCode(this.getExperimental());
        }
        return hash;
    }

    public static ClientCapabilities create() {
        JSONObject json = new JSONObject();
        return new ClientCapabilities(json);
    }

    public static class WindowCapabilities
    extends JSONBase {
        WindowCapabilities(JSONObject jsonData) {
            super(jsonData);
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean getWorkDoneProgress() {
            return this.jsonData.has("workDoneProgress") ? Boolean.valueOf(this.jsonData.getBoolean("workDoneProgress")) : null;
        }

        public WindowCapabilities setWorkDoneProgress(Boolean workDoneProgress) {
            this.jsonData.putOpt("workDoneProgress", workDoneProgress);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WindowCapabilities other = (WindowCapabilities)obj;
            return Objects.equals(this.getWorkDoneProgress(), other.getWorkDoneProgress());
        }

        public int hashCode() {
            int hash = 7;
            if (this.getWorkDoneProgress() != null) {
                hash = 43 * hash + Boolean.hashCode(this.getWorkDoneProgress());
            }
            return hash;
        }
    }
}

