/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.tools.lsp.instrument;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.graalvm.collections.Pair;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionType;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Instrument;
import org.graalvm.tools.lsp.exceptions.LSPIOException;
import org.graalvm.tools.lsp.instrument.EnvironmentProvider;
import org.graalvm.tools.lsp.instrument.LSPInstrumentOptionDescriptors;
import org.graalvm.tools.lsp.server.ContextAwareExecutor;
import org.graalvm.tools.lsp.server.LSPFileSystem;
import org.graalvm.tools.lsp.server.LanguageServerImpl;
import org.graalvm.tools.lsp.server.TruffleAdapter;
import org.graalvm.tools.lsp.server.utils.CoverageEventNode;

@TruffleInstrument.Registration(id="lsp", name="Language Server", version="0.1", services={EnvironmentProvider.class})
public final class LSPInstrument
extends TruffleInstrument
implements EnvironmentProvider {
    public static final String ID = "lsp";
    private static final int DEFAULT_PORT = 8123;
    private static final HostAndPort DEFAULT_ADDRESS = new HostAndPort(null, 8123);
    private OptionValues options;
    private TruffleInstrument.Env environment;
    private EventBinding<ExecutionEventNodeFactory> eventFactoryBinding;
    private volatile boolean waitForClose = false;
    static final OptionType<HostAndPort> ADDRESS_OR_BOOLEAN = new OptionType("[[host:]port]", address -> {
        if (address.isEmpty() || address.equals("true")) {
            return DEFAULT_ADDRESS;
        }
        return HostAndPort.parse(address);
    }, address -> address.verify());
    static final OptionType<List<LanguageAndAddress>> DELEGATES = new OptionType("[languageId@][[host:]port],...", addresses -> {
        if (addresses.isEmpty()) {
            return Collections.emptyList();
        }
        String[] array = addresses.split(",");
        ArrayList<LanguageAndAddress> hostPorts = new ArrayList<LanguageAndAddress>(array.length);
        for (String address : array) {
            hostPorts.add(LanguageAndAddress.parse(address));
        }
        return hostPorts;
    }, addresses -> addresses.forEach(address -> address.verify()));
    @Option(help="Enable features for language developers, e.g. hovering code snippets shows AST related information like the node class or tags. (default:false)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> DeveloperMode = new OptionKey((Object)false);
    @Option(help="Include internal sources in goto-definition, references and symbols search. (default:false)", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> Internal = new OptionKey((Object)false);
    @Option(name="", help="Start the Language Server on [[host:]port]. (default: <loopback address>:8123)", category=OptionCategory.USER)
    static final OptionKey<HostAndPort> Lsp = new OptionKey((Object)DEFAULT_ADDRESS, ADDRESS_OR_BOOLEAN);
    @Option(help="Requested maximum length of the Socket queue of incoming connections. (default: -1)", category=OptionCategory.EXPERT)
    static final OptionKey<Integer> SocketBacklogSize = new OptionKey((Object)-1);
    @Option(help="Delegate language servers", category=OptionCategory.USER)
    static final OptionKey<List<LanguageAndAddress>> Delegates = new OptionKey(Collections.emptyList(), DELEGATES);

    protected void onCreate(TruffleInstrument.Env env) {
        env.registerService((Object)this);
        this.environment = env;
        this.options = env.getOptions();
        if (this.options.hasSetOptions()) {
            final TruffleAdapter truffleAdapter = this.launchServer(new PrintWriter(env.out(), true), new PrintWriter(env.err(), true));
            SourceSectionFilter eventFilter = SourceSectionFilter.newBuilder().includeInternal(((Boolean)this.options.get(Internal)).booleanValue()).build();
            this.eventFactoryBinding = env.getInstrumenter().attachExecutionEventFactory(eventFilter, new ExecutionEventNodeFactory(){
                private final long creatorThreadId = Thread.currentThread().getId();

                public ExecutionEventNode create(EventContext eventContext) {
                    SourceSection section = eventContext.getInstrumentedSourceSection();
                    if (section != null && section.isAvailable()) {
                        Node instrumentedNode = eventContext.getInstrumentedNode();
                        return new CoverageEventNode(section, instrumentedNode, null, truffleAdapter.surrogateGetter(instrumentedNode.getRootNode().getLanguageInfo()), this.creatorThreadId);
                    }
                    return null;
                }
            });
        }
    }

    protected void onDispose(TruffleInstrument.Env env) {
        if (this.eventFactoryBinding != null) {
            this.eventFactoryBinding.dispose();
        }
    }

    protected void onFinalize(TruffleInstrument.Env env) {
        if (this.waitForClose) {
            PrintWriter info = new PrintWriter(env.out());
            info.println("Waiting for the language client to disconnect...");
            info.flush();
            this.waitForClose();
        }
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new LSPInstrumentOptionDescriptors();
    }

    @Override
    public TruffleInstrument.Env getEnvironment() {
        return this.environment;
    }

    private void setWaitForClose() {
        this.waitForClose = true;
    }

    public synchronized void waitForClose() {
        while (this.waitForClose) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    private synchronized void notifyClose() {
        this.waitForClose = false;
        this.notifyAll();
    }

    private TruffleAdapter launchServer(PrintWriter info, PrintWriter err) {
        assert (this.options != null);
        assert (this.options.hasSetOptions());
        TruffleAdapter truffleAdapter = new TruffleAdapter(this.environment, (Boolean)this.options.get(DeveloperMode));
        Context.Builder builder = Context.newBuilder((String[])new String[0]);
        builder.allowAllAccess(true);
        builder.engine(Engine.create());
        builder.fileSystem(LSPFileSystem.newReadOnlyFileSystem(truffleAdapter));
        ContextAwareExecutorImpl executorWrapper = new ContextAwareExecutorImpl(builder);
        this.setWaitForClose();
        executorWrapper.executeWithDefaultContext(() -> {
            HostAndPort hostAndPort = (HostAndPort)this.options.get(Lsp);
            try {
                Context context = builder.build();
                context.enter();
                Instrument instrument = (Instrument)context.getEngine().getInstruments().get(ID);
                EnvironmentProvider envProvider = (EnvironmentProvider)instrument.lookup(EnvironmentProvider.class);
                truffleAdapter.register(envProvider.getEnvironment(), executorWrapper);
                InetSocketAddress socketAddress = hostAndPort.createSocket();
                int port = socketAddress.getPort();
                Integer backlog = (Integer)this.options.get(SocketBacklogSize);
                InetAddress address = socketAddress.getAddress();
                ServerSocket serverSocket = new ServerSocket(port, backlog, address);
                List<Pair<String, SocketAddress>> delegates = LSPInstrument.createDelegateSockets((List)this.options.get(Delegates));
                ((CompletableFuture)LanguageServerImpl.create(truffleAdapter, info, err).start(serverSocket, delegates).thenRun(() -> {
                    try {
                        executorWrapper.executeWithDefaultContext(() -> {
                            context.leave();
                            return null;
                        }).get();
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                    executorWrapper.shutdown();
                    this.notifyClose();
                })).exceptionally(throwable -> {
                    throwable.printStackTrace(err);
                    this.notifyClose();
                    return null;
                });
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable e) {
                String message = String.format("[Graal LSP] Starting server on %s failed: %s", hostAndPort.getHostPort(), e.getLocalizedMessage());
                new LSPIOException(message, e).printStackTrace(err);
            }
            return null;
        });
        return truffleAdapter;
    }

    private static List<Pair<String, SocketAddress>> createDelegateSockets(List<LanguageAndAddress> hostPorts) {
        if (hostPorts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, SocketAddress>> sockets = new ArrayList<Pair<String, SocketAddress>>(hostPorts.size());
        for (LanguageAndAddress langAddress : hostPorts) {
            sockets.add((Pair<String, SocketAddress>)Pair.create((Object)langAddress.getLanguageId(), (Object)langAddress.getAddress().createSocket()));
        }
        return sockets;
    }

    static final class LanguageAndAddress {
        private final String languageId;
        private final HostAndPort address;

        private LanguageAndAddress(String languageId, HostAndPort address) {
            this.languageId = languageId;
            this.address = address;
        }

        static LanguageAndAddress parse(String la) {
            int at = la.indexOf(64);
            if (at < 0) {
                return new LanguageAndAddress(null, HostAndPort.parse(la));
            }
            return new LanguageAndAddress(la.substring(0, at), HostAndPort.parse(la.substring(at + 1)));
        }

        void verify() {
            if (this.languageId != null && this.languageId.isEmpty()) {
                throw new IllegalArgumentException("Unknown empty language specified.");
            }
            this.address.verify();
        }

        String getLanguageId() {
            return this.languageId;
        }

        HostAndPort getAddress() {
            return this.address;
        }
    }

    static final class HostAndPort {
        private final String host;
        private String portStr;
        private int port;
        private InetAddress inetAddress;

        private HostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        private HostAndPort(String host, String portStr) {
            this.host = host;
            this.portStr = portStr;
        }

        static HostAndPort parse(String address) {
            String host;
            String port;
            int colon = address.indexOf(58);
            if (colon >= 0) {
                port = address.substring(colon + 1);
                host = address.substring(0, colon);
            } else {
                port = address;
                host = null;
            }
            return new HostAndPort(host, port);
        }

        void verify() {
            if (this.port == 0) {
                try {
                    this.port = Integer.parseInt(this.portStr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Port is not a number: " + this.portStr);
                }
            }
            if (this.port <= 0 || this.port > 65535) {
                throw new IllegalArgumentException("Invalid port number: " + this.port);
            }
            if (this.host != null && !this.host.isEmpty()) {
                try {
                    this.inetAddress = InetAddress.getByName(this.host);
                }
                catch (UnknownHostException ex) {
                    throw new IllegalArgumentException(ex.getLocalizedMessage(), ex);
                }
            }
        }

        String getHostPort() {
            String hostName = this.host;
            if (hostName == null || hostName.isEmpty()) {
                hostName = this.inetAddress != null ? this.inetAddress.toString() : InetAddress.getLoopbackAddress().toString();
            }
            return hostName + ":" + this.port;
        }

        InetSocketAddress createSocket() {
            InetAddress ia = this.inetAddress == null ? InetAddress.getLoopbackAddress() : this.inetAddress;
            return new InetSocketAddress(ia, this.port);
        }
    }

    private static final class ContextAwareExecutorImpl
    implements ContextAwareExecutor {
        private final Context.Builder contextBuilder;
        static final String WORKER_THREAD_ID = "LS Context-aware Worker";
        Context lastNestedContext = null;
        private volatile WeakReference<Thread> workerThread = new WeakReference<Object>(null);
        private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
            private final ThreadFactory factory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.factory.newThread(r);
                thread.setName(ContextAwareExecutorImpl.WORKER_THREAD_ID);
                workerThread = new WeakReference<Thread>(thread);
                return thread;
            }
        });

        private ContextAwareExecutorImpl(Context.Builder contextBuilder) {
            this.contextBuilder = contextBuilder;
        }

        @Override
        public <T> Future<T> executeWithDefaultContext(Callable<T> taskWithResult) {
            return this.execute(taskWithResult);
        }

        @Override
        public <T> Future<T> executeWithNestedContext(Callable<T> taskWithResult, boolean cached) {
            return this.execute(this.wrapWithNewContext(taskWithResult, cached));
        }

        @Override
        public <T> Future<T> executeWithNestedContext(Callable<T> taskWithResult, int timeoutMillis, Callable<T> onTimeoutTask) {
            if (timeoutMillis <= 0) {
                return this.executeWithNestedContext(taskWithResult);
            }
            Future<T> future = this.execute(this.wrapWithNewContext(taskWithResult, false));
            try {
                return CompletableFuture.completedFuture(future.get(timeoutMillis, TimeUnit.MILLISECONDS));
            }
            catch (TimeoutException e) {
                future.cancel(true);
                try {
                    return CompletableFuture.completedFuture(onTimeoutTask.call());
                }
                catch (Exception timeoutTaskException) {
                    CompletableFuture cf = new CompletableFuture();
                    cf.completeExceptionally(timeoutTaskException);
                    return cf;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                CompletableFuture cf = new CompletableFuture();
                cf.completeExceptionally(e);
                return cf;
            }
        }

        private <T> Future<T> execute(Callable<T> taskWithResult) {
            if (Thread.currentThread() == this.workerThread.get()) {
                FutureTask<T> futureTask = new FutureTask<T>(taskWithResult);
                futureTask.run();
                return futureTask;
            }
            return this.executor.submit(taskWithResult);
        }

        private <T> Callable<T> wrapWithNewContext(final Callable<T> taskWithResult, final boolean cached) {
            return new Callable<T>(){

                @Override
                public T call() throws Exception {
                    Context context;
                    if (cached) {
                        if (lastNestedContext == null) {
                            lastNestedContext = contextBuilder.build();
                        }
                        context = lastNestedContext;
                    } else {
                        context = contextBuilder.build();
                    }
                    try {
                        Object v;
                        context.enter();
                        try {
                            v = taskWithResult.call();
                        }
                        catch (Throwable throwable) {
                            context.leave();
                            throw throwable;
                        }
                        context.leave();
                        return v;
                    }
                    finally {
                        if (!cached) {
                            context.close();
                        }
                    }
                }
            };
        }

        @Override
        public void shutdown() {
            this.executor.shutdownNow();
        }

        @Override
        public void resetContextCache() {
            if (this.lastNestedContext != null) {
                this.lastNestedContext.close();
            }
            this.lastNestedContext = this.contextBuilder.build();
        }
    }
}

