/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.pecoff.cv.CVUtil;
import java.util.ArrayList;

abstract class CVTypeRecord {
    protected final short type;
    private int startPosition;
    private int sequenceNumber;

    CVTypeRecord(short type) {
        this.type = type;
        this.startPosition = -1;
        this.sequenceNumber = -1;
    }

    int getSequenceNumber() {
        return this.sequenceNumber;
    }

    void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    int computeFullSize(int initialPos) {
        this.startPosition = initialPos;
        int pos = initialPos + 4;
        pos = this.computeSize(pos);
        pos = CVTypeRecord.alignPadded4(null, pos);
        return pos;
    }

    int computeFullContents(byte[] buffer, int initialPos) {
        int pos = initialPos + 2;
        pos = CVUtil.putShort(this.type, buffer, pos);
        pos = this.computeContents(buffer, pos);
        pos = CVTypeRecord.alignPadded4(buffer, pos);
        short length = (short)(pos - initialPos - 2);
        CVUtil.putShort(length, buffer, initialPos);
        return pos;
    }

    protected abstract int computeSize(int var1);

    protected abstract int computeContents(byte[] var1, int var2);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.type == ((CVTypeRecord)obj).type;
    }

    public abstract int hashCode();

    public String toString() {
        return String.format("CVTypeRecord seq=0x%04x type=0x%04x pos=0x%04x ", this.sequenceNumber, this.type, this.startPosition);
    }

    private static int alignPadded4(byte[] buffer, int originalpos) {
        int pos = originalpos;
        int align = pos & 3;
        if (align == 1) {
            byte[] p3 = new byte[]{-13, -14, -15};
            pos = CVUtil.putBytes(p3, buffer, pos);
        } else if (align == 2) {
            pos = CVUtil.putByte((byte)-14, buffer, pos);
            pos = CVUtil.putByte((byte)-15, buffer, pos);
        } else if (align == 3) {
            pos = CVUtil.putByte((byte)-15, buffer, pos);
        }
        return pos;
    }

    static final class CVTypeArglistRecord
    extends CVTypeRecord {
        ArrayList<Integer> args = new ArrayList();

        CVTypeArglistRecord() {
            super((short)4609);
        }

        CVTypeArglistRecord add(int argType) {
            this.args.add(argType);
            return this;
        }

        @Override
        public int computeSize(int initialPos) {
            return initialPos + 4 + 4 * this.args.size();
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.args.size(), buffer, initialPos);
            for (Integer at : this.args) {
                pos = CVUtil.putInt(at, buffer, pos);
            }
            return pos;
        }

        int getSize() {
            return this.args.size();
        }

        @Override
        public String toString() {
            StringBuilder s = new StringBuilder(String.format("LF_ARGLIST 0x%04x [", this.getSequenceNumber()));
            for (Integer at : this.args) {
                s.append(String.format(" 0x%04x", at));
            }
            s.append("])");
            return s.toString();
        }

        @Override
        public int hashCode() {
            return this.type * 31 + this.args.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVTypeArglistRecord other = (CVTypeArglistRecord)obj;
            return this.args.equals(other.args);
        }
    }

    static final class CVTypeProcedureRecord
    extends CVTypeRecord {
        int returnType = -1;
        CVTypeArglistRecord argList = null;

        CVTypeProcedureRecord() {
            super((short)4104);
        }

        public CVTypeProcedureRecord returnType(int leaf) {
            this.returnType = leaf;
            return this;
        }

        public CVTypeProcedureRecord returnType(CVTypeRecord leaf) {
            this.returnType = leaf.getSequenceNumber();
            return this;
        }

        CVTypeProcedureRecord argList(CVTypeArglistRecord leaf) {
            this.argList = leaf;
            return this;
        }

        @Override
        public int computeSize(int initialPos) {
            return this.computeContents(null, initialPos);
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.returnType, buffer, initialPos);
            pos = CVUtil.putByte((byte)0, buffer, pos);
            pos = CVUtil.putByte((byte)0, buffer, pos);
            pos = CVUtil.putShort((short)this.argList.getSize(), buffer, pos);
            pos = CVUtil.putInt(this.argList.getSequenceNumber(), buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return String.format("LF_PROCEDURE 0x%04x ret=0x%04x arg=0x%04x ", this.getSequenceNumber(), this.returnType, this.argList.getSequenceNumber());
        }

        @Override
        public int hashCode() {
            int h = this.type;
            h = 31 * h + this.returnType;
            h = 31 * h + this.argList.hashCode();
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVTypeProcedureRecord other = (CVTypeProcedureRecord)obj;
            return this.returnType == other.returnType && this.argList == other.argList;
        }
    }
}

