/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.macho;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.objectfile.macho.MachOObjectFile;
import com.oracle.objectfile.macho.MachORelocationElement;
import com.oracle.objectfile.macho.RelocationInfo;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;

public class MachOUserDefinedSection
extends MachOObjectFile.MachOSection
implements ObjectFile.RelocatableSectionImpl {
    protected ElementImpl impl;

    @Override
    public ElementImpl getImpl() {
        return this.impl;
    }

    MachOUserDefinedSection(MachOObjectFile owner, String name, int alignment, MachOObjectFile.Segment64Command segment, MachOObjectFile.SectionType type, ElementImpl impl) {
        this(owner, name, alignment, segment, type, impl, EnumSet.noneOf(MachOObjectFile.SectionFlag.class));
        this.impl = impl;
    }

    MachOUserDefinedSection(MachOObjectFile owner, String name, int alignment, MachOObjectFile.Segment64Command segment, MachOObjectFile.SectionType type, ElementImpl impl, EnumSet<MachOObjectFile.SectionFlag> flags) {
        MachOObjectFile machOObjectFile = owner;
        Objects.requireNonNull(machOObjectFile);
        super(name, alignment, segment, type, flags);
        this.impl = impl;
    }

    public void setImpl(ElementImpl impl) {
        this.impl = impl;
    }

    @Override
    public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        return this.impl.getDependencies(decisions);
    }

    @Override
    public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
        int implOffset = this.impl.getOrDecideOffset(alreadyDecided, offsetHint);
        ObjectFile.Segment ourSegment = this.getSegment();
        ObjectFile.Segment prevSegment = null;
        ObjectFile.Segment firstSegment = this.getOwner().getSegments().iterator().next();
        for (ObjectFile.Segment s : this.getOwner().getSegments()) {
            if (s == ourSegment) break;
            prevSegment = s;
        }
        if (this.getSegment().get(0) == this && prevSegment != null && prevSegment.getName().equals("__TEXT")) {
            assert (prevSegment == firstSegment);
            if (implOffset < this.getOwner().getPageSize()) {
                return ObjectFile.nextIntegerMultipleWithCongruence(this.getOwner().getPageSize(), this.impl.getAlignment(), implOffset, this.getOwner().getPageSize());
            }
        } else if (this.getSegment().get(0) == this && ourSegment == firstSegment && implOffset < this.getOwner().getPageSize()) {
            return this.getOwner().getPageSize();
        }
        return implOffset;
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        return this.impl.getOrDecideSize(alreadyDecided, sizeHint);
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        return this.impl.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
        int implVaddr = this.impl.getOrDecideVaddr(alreadyDecided, vaddrHint);
        Object offsetObj = alreadyDecided.get(this).getDecidedValue(LayoutDecision.Kind.OFFSET);
        assert (offsetObj != null);
        assert (offsetObj instanceof Integer);
        if (this.getSegment() == this.getOwner().getSegments().iterator().next() && this.getSegment().get(0) == this && implVaddr < this.getOwner().getPageSize()) {
            return ObjectFile.nextIntegerMultipleWithCongruence(this.getOwner().getPageSize(), this.impl.getAlignment(), (Integer)offsetObj, this.getOwner().getPageSize());
        }
        return implVaddr;
    }

    @Override
    public int getMemSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
        return this.impl.getMemSize(alreadyDecided);
    }

    @Override
    public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
        return this.impl.getDecisions(copyingIn);
    }

    @Override
    public MachORelocationElement getOrCreateRelocationElement(boolean useImplicitAddend) {
        return this.getOwner().getOrCreateRelocationElement(useImplicitAddend);
    }

    @Override
    public ObjectFile.RelocationRecord markRelocationSite(int offset, ByteBuffer bb, ObjectFile.RelocationKind k, String symbolName, boolean useImplicitAddend, Long explicitAddend) {
        long desiredInlineAddendValue;
        MachORelocationElement el = this.getOrCreateRelocationElement(useImplicitAddend);
        AssemblyBuffer sbb = new AssemblyBuffer(bb);
        sbb.setByteOrder(this.getOwner().getByteOrder());
        sbb.pushSeek(offset);
        int length = ObjectFile.RelocationKind.getRelocationSize(k);
        long currentInlineAddendValue = sbb.readTruncatedLong(length);
        if (explicitAddend != null) {
            assert (currentInlineAddendValue == 0L);
            desiredInlineAddendValue = explicitAddend;
        } else {
            desiredInlineAddendValue = currentInlineAddendValue;
        }
        if (ObjectFile.RelocationKind.isPCRelative(k)) {
            desiredInlineAddendValue += (long)length;
        }
        sbb.seek(offset);
        sbb.writeTruncatedLong(desiredInlineAddendValue, length);
        assert (symbolName != null);
        ObjectFile.Symbol sym = this.getOwner().getSymbolTable().getSymbol(symbolName);
        boolean symbolIsDefinedLocally = sym != null && sym.isDefined();
        boolean createAsLocalReloc = false;
        assert (!createAsLocalReloc || symbolIsDefinedLocally);
        this.flags.add(createAsLocalReloc ? MachOObjectFile.SectionFlag.LOC_RELOC : MachOObjectFile.SectionFlag.EXT_RELOC);
        sbb.pop();
        RelocationInfo rec = new RelocationInfo(el, this, offset, length, k, symbolName, createAsLocalReloc);
        el.add(rec);
        return rec;
    }
}

