/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.truffle.nfi.NativeAPI;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_NFIContext;
import com.oracle.svm.truffle.nfi.TruffleNFISupport;
import com.oracle.svm.truffle.nfi.TruffleObjectHandle;
import com.oracle.truffle.api.interop.TruffleObject;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class NativeAPIImpl {
    static final CEntryPointLiteral<NativeAPI.GetTruffleContextFunction> GET_TRUFFLE_CONTEXT = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"getTruffleContext", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class});
    static final CEntryPointLiteral<NativeAPI.NewObjectRefFunction> NEW_OBJECT_REF = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"newObjectRef", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, TruffleObjectHandle.class});
    static final CEntryPointLiteral<NativeAPI.ReleaseObjectRefFunction> RELEASE_OBJECT_REF = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"releaseObjectRef", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, TruffleObjectHandle.class});
    static final CEntryPointLiteral<NativeAPI.ReleaseAndReturnFunction> RELEASE_AND_RETURN = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"releaseAndReturn", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, TruffleObjectHandle.class});
    static final CEntryPointLiteral<NativeAPI.IsSameObjectFunction> IS_SAME_OBJECT = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"isSameObject", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, TruffleObjectHandle.class, TruffleObjectHandle.class});
    static final CEntryPointLiteral<NativeAPI.NewClosureRefFunction> NEW_CLOSURE_REF = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"newClosureRef", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, PointerBase.class});
    static final CEntryPointLiteral<NativeAPI.ReleaseClosureRefFunction> RELEASE_CLOSURE_REF = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"releaseClosureRef", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, PointerBase.class});
    static final CEntryPointLiteral<NativeAPI.GetClosureObjectFunction> GET_CLOSURE_OBJECT = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"getClosureObject", (Class[])new Class[]{NativeAPI.NativeTruffleEnv.class, PointerBase.class});
    static final CEntryPointLiteral<NativeAPI.GetTruffleEnvFunction> GET_TRUFFLE_ENV = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"getTruffleEnv", (Class[])new Class[]{NativeAPI.NativeTruffleContext.class});
    static final CEntryPointLiteral<NativeAPI.AttachCurrentThreadFunction> ATTACH_CURRENT_THREAD = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"attachCurrentThread", (Class[])new Class[]{NativeAPI.NativeTruffleContext.class});
    static final CEntryPointLiteral<NativeAPI.DetachCurrentThreadFunction> DETACH_CURRENT_THREAD = CEntryPointLiteral.create(NativeAPIImpl.class, (String)"detachCurrentThread", (Class[])new Class[]{NativeAPI.NativeTruffleContext.class});

    NativeAPIImpl() {
    }

    private static Target_com_oracle_truffle_nfi_impl_NFIContext lookupContext(NativeAPI.NativeTruffleContext context) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        return support.resolveContextHandle(context.contextHandle());
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static NativeAPI.NativeTruffleContext getTruffleContext(NativeAPI.NativeTruffleEnv env) {
        return env.context();
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static TruffleObjectHandle newObjectRef(NativeAPI.NativeTruffleEnv env, TruffleObjectHandle handle) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        Object object = support.resolveHandle(handle);
        return support.createGlobalHandle(object);
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static void releaseObjectRef(NativeAPI.NativeTruffleEnv env, TruffleObjectHandle handle) {
        ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).destroyGlobalHandle(handle);
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static TruffleObjectHandle releaseAndReturn(NativeAPI.NativeTruffleEnv env, TruffleObjectHandle handle) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        Object object = support.resolveHandle(handle);
        support.destroyGlobalHandle(handle);
        return TruffleNFISupport.createLocalHandle(object);
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static int isSameObject(NativeAPI.NativeTruffleEnv env, TruffleObjectHandle handle1, TruffleObjectHandle handle2) {
        Object object2;
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        Object object1 = support.resolveHandle(handle1);
        return object1 == (object2 = support.resolveHandle(handle2)) ? 1 : 0;
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static void newClosureRef(NativeAPI.NativeTruffleEnv env, PointerBase closure) {
        Target_com_oracle_truffle_nfi_impl_NFIContext context = NativeAPIImpl.lookupContext(env.context());
        context.newClosureRef(closure.rawValue());
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static void releaseClosureRef(NativeAPI.NativeTruffleEnv env, PointerBase closure) {
        Target_com_oracle_truffle_nfi_impl_NFIContext context = NativeAPIImpl.lookupContext(env.context());
        context.releaseClosureRef(closure.rawValue());
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=EnterNativeTruffleEnvPrologue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static TruffleObjectHandle getClosureObject(NativeAPI.NativeTruffleEnv env, PointerBase closure) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        Target_com_oracle_truffle_nfi_impl_NFIContext context = NativeAPIImpl.lookupContext(env.context());
        TruffleObject ret = context.getClosureObject(closure.rawValue());
        return support.createGlobalHandle(ret);
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=GetTruffleEnvPrologue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static NativeAPI.NativeTruffleEnv getTruffleEnv(NativeAPI.NativeTruffleContext context) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        Target_com_oracle_truffle_nfi_impl_NFIContext ctx = support.resolveContextHandle(context.contextHandle());
        return (NativeAPI.NativeTruffleEnv)WordFactory.pointer((long)ctx.getNativeEnv());
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AttachCurrentThreadPrologue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static NativeAPI.NativeTruffleEnv attachCurrentThread(NativeAPI.NativeTruffleContext context) {
        TruffleNFISupport support = (TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class);
        Target_com_oracle_truffle_nfi_impl_NFIContext ctx = support.resolveContextHandle(context.contextHandle());
        return (NativeAPI.NativeTruffleEnv)WordFactory.pointer((long)ctx.getNativeEnv());
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=EnterNativeTruffleContextPrologue.class, epilogue=CEntryPointSetup.LeaveDetachThreadEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static void detachCurrentThread(NativeAPI.NativeTruffleContext context) {
    }

    static class EnterNativeTruffleEnvPrologue {
        EnterNativeTruffleEnvPrologue() {
        }

        static void enter(NativeAPI.NativeTruffleEnv env) {
            CEntryPointActions.enter(env.isolateThread());
        }
    }

    static class EnterNativeTruffleContextPrologue {
        EnterNativeTruffleContextPrologue() {
        }

        static void enter(NativeAPI.NativeTruffleContext context) {
            CEntryPointActions.enterIsolate(context.isolate());
        }
    }

    static class AttachCurrentThreadPrologue {
        AttachCurrentThreadPrologue() {
        }

        static void enter(NativeAPI.NativeTruffleContext context) {
            if (CEntryPointActions.enterAttachThread(context.isolate(), true) != 0) {
                CEntryPointActions.bailoutInPrologue((WordBase)WordFactory.nullPointer());
            }
        }
    }

    static class GetTruffleEnvPrologue {
        GetTruffleEnvPrologue() {
        }

        static void enter(NativeAPI.NativeTruffleContext context) {
            if (CEntryPointActions.enterIsolate(context.isolate()) != 0) {
                CEntryPointActions.bailoutInPrologue((WordBase)WordFactory.nullPointer());
            }
        }
    }
}

