/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.truffle.isolated.IsolatedCompilationResultData;
import com.oracle.svm.truffle.isolated.IsolatedCompilationResultInfo;
import com.oracle.svm.truffle.isolated.IsolatedEventContext;
import com.oracle.svm.truffle.isolated.IsolatedGraphInfo;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleMetaAccessProvider;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;

final class IsolatedTruffleCompilerEventForwarder
implements TruffleCompilerListener {
    private final ClientHandle<IsolatedEventContext> contextHandle;

    IsolatedTruffleCompilerEventForwarder(ClientHandle<IsolatedEventContext> contextHandle) {
        this.contextHandle = contextHandle;
    }

    public void onGraalTierFinished(CompilableTruffleAST compilable, TruffleCompilerListener.GraphInfo graph) {
        IsolatedTruffleCompilerEventForwarder.onGraalTierFinished0(IsolatedCompileContext.get().getClient(), this.contextHandle, IsolatedCompileContext.get().hand(graph), graph.getNodeCount());
    }

    public void onTruffleTierFinished(CompilableTruffleAST compilable, TruffleMetaAccessProvider inliningPlan, TruffleCompilerListener.GraphInfo graph) {
        IsolatedTruffleCompilerEventForwarder.onTruffleTierFinished0(IsolatedCompileContext.get().getClient(), this.contextHandle, IsolatedCompileContext.get().hand(graph), graph.getNodeCount());
    }

    public void onSuccess(CompilableTruffleAST compilable, TruffleMetaAccessProvider inliningPlan, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo info) {
        IsolatedCompilationResultData data = (IsolatedCompilationResultData)StackValue.get(IsolatedCompilationResultData.class);
        data.setOriginalObjectHandle(IsolatedCompileContext.get().hand(info));
        data.setTargetCodeSize(info.getTargetCodeSize());
        data.setTotalFrameSize(info.getTotalFrameSize());
        data.setExceptionHandlersCount(info.getExceptionHandlersCount());
        data.setInfopointsCount(info.getInfopointsCount());
        data.setMarksCount(info.getMarksCount());
        data.setDataPatchesCount(info.getDataPatchesCount());
        IsolatedTruffleCompilerEventForwarder.onSuccess0(IsolatedCompileContext.get().getClient(), this.contextHandle, IsolatedCompileContext.get().hand(graph), graph.getNodeCount(), data);
    }

    public void onFailure(CompilableTruffleAST compilable, String reason, boolean bailout, boolean permanentBailout) {
        try (CTypeConversion.CCharPointerHolder reasonCstr = CTypeConversion.toCString((CharSequence)reason);){
            IsolatedTruffleCompilerEventForwarder.onFailure0(IsolatedCompileContext.get().getClient(), this.contextHandle, reasonCstr.get(), bailout, permanentBailout);
        }
    }

    public void onCompilationRetry(CompilableTruffleAST compilable) {
        IsolatedTruffleCompilerEventForwarder.onCompilationRetry0(IsolatedCompileContext.get().getClient(), this.contextHandle);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void onGraalTierFinished0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle, CompilerHandle<TruffleCompilerListener.GraphInfo> graphInfo, int nodeCount) {
        IsolatedEventContext context = IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onGraalTierFinished(context.compilable, (TruffleCompilerListener.GraphInfo)new IsolatedGraphInfo(graphInfo, nodeCount));
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void onTruffleTierFinished0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle, CompilerHandle<TruffleCompilerListener.GraphInfo> graphInfo, int nodeCount) {
        IsolatedEventContext context = IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onTruffleTierFinished(context.compilable, context.inlining, (TruffleCompilerListener.GraphInfo)new IsolatedGraphInfo(graphInfo, nodeCount));
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void onSuccess0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle, CompilerHandle<TruffleCompilerListener.GraphInfo> graphInfo, int nodeCount, IsolatedCompilationResultData resultData) {
        IsolatedEventContext context = IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onSuccess(context.compilable, context.inlining, (TruffleCompilerListener.GraphInfo)new IsolatedGraphInfo(graphInfo, nodeCount), (TruffleCompilerListener.CompilationResultInfo)new IsolatedCompilationResultInfo(resultData));
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void onFailure0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle, CCharPointer reason, boolean bailout, boolean permanentBailout) {
        IsolatedEventContext context = IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onFailure(context.compilable, CTypeConversion.toJavaString((CCharPointer)reason), bailout, permanentBailout);
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static void onCompilationRetry0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle) {
        IsolatedEventContext context = IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onCompilationRetry(context.compilable);
    }
}

