/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import org.graalvm.nativeimage.IsolateThread;

public class JavaFrameAnchors {
    private static final FastThreadLocalWord<JavaFrameAnchor> lastAnchor = (FastThreadLocalWord)FastThreadLocalFactory.createWord().setMaxOffset(127);

    public static void pushFrameAnchor(JavaFrameAnchor anchor) {
        anchor.setPreviousAnchor(lastAnchor.get());
        lastAnchor.set(anchor);
    }

    public static JavaFrameAnchor popFrameAnchor() {
        JavaFrameAnchor result = lastAnchor.get();
        lastAnchor.set(result.getPreviousAnchor());
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JavaFrameAnchor getFrameAnchor() {
        return lastAnchor.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JavaFrameAnchor getFrameAnchor(IsolateThread vmThread) {
        return lastAnchor.get(vmThread);
    }
}

