/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import java.lang.reflect.Array;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

final class Util_java_lang_reflect_Array {
    Util_java_lang_reflect_Array() {
    }

    static Object createMultiArrayAtIndex(int index, DynamicHub arrayHub, int[] dimensions) {
        int length = dimensions[index];
        Object result = Array.newInstance(DynamicHub.toClass(arrayHub.getComponentHub()), length);
        int nextIndex = index + 1;
        if (nextIndex < dimensions.length && length > 0) {
            DynamicHub subArrayHub = arrayHub.getComponentHub();
            UnsignedWord offset = LayoutEncoding.getArrayBaseOffset(arrayHub.getLayoutEncoding());
            UnsignedWord endOffset = LayoutEncoding.getArrayElementOffset(arrayHub.getLayoutEncoding(), length);
            while (offset.belowThan(endOffset)) {
                Object subArray = Util_java_lang_reflect_Array.createMultiArrayAtIndex(nextIndex, subArrayHub, dimensions);
                BarrieredAccess.writeObject((Object)result, (WordBase)offset, (Object)subArray);
                offset = offset.add(ConfigurationValues.getObjectLayout().getReferenceSize());
            }
        }
        return result;
    }
}

