/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.LocalizationSupport;
import com.oracle.svm.core.jdk.Target_java_lang_Module;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=ResourceBundle.class)
final class Target_java_util_ResourceBundle {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    private static ConcurrentMap<?, ?> cacheList = new ConcurrentHashMap();

    Target_java_util_ResourceBundle() {
    }

    @Substitute
    private static ResourceBundle getBundle(String baseName) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).getCached(baseName, Locale.getDefault());
    }

    @Substitute
    private static ResourceBundle getBundle(String baseName, ResourceBundle.Control control) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).getCached(baseName, Locale.getDefault());
    }

    @Substitute
    private static ResourceBundle getBundle(String baseName, Locale locale) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).getCached(baseName, locale);
    }

    @Substitute
    private static ResourceBundle getBundle(String baseName, Locale targetLocale, ResourceBundle.Control control) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).getCached(baseName, targetLocale);
    }

    @Substitute
    private static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).getCached(baseName, locale);
    }

    @Substitute
    private static ResourceBundle getBundle(String baseName, Locale targetLocale, ClassLoader loader, ResourceBundle.Control control) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).getCached(baseName, targetLocale);
    }

    @TargetElement(onlyWith={JDK11OrLater.class})
    @Substitute
    private static ResourceBundle getBundle(String baseName, Target_java_lang_Module module) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).getCached(baseName, Locale.getDefault());
    }

    @TargetElement(onlyWith={JDK11OrLater.class})
    @Substitute
    private static ResourceBundle getBundle(String baseName, Locale targetLocale, Target_java_lang_Module module) {
        return ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).getCached(baseName, targetLocale);
    }
}

