/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.jdk.ClassLoaderSupport;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

class PackageFieldTransformer
implements RecomputeFieldValue.CustomFieldValueTransformer {
    PackageFieldTransformer() {
    }

    @Override
    public Object transform(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver, Object originalValue) {
        assert (receiver instanceof ClassLoader);
        boolean useConcurrentHashMap = originalValue instanceof ConcurrentHashMap;
        ConcurrentHashMap<String, Package> packages = ClassLoaderSupport.getRegisteredPackages((ClassLoader)receiver);
        if (packages == null) {
            return useConcurrentHashMap ? new ConcurrentHashMap() : new HashMap();
        }
        return useConcurrentHashMap ? packages : new HashMap<String, Package>(packages);
    }
}

