/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.jdk;

import com.oracle.svm.core.graal.jdk.ArraycopySnippets;
import com.oracle.svm.core.graal.jdk.SubstrateArraysCopyOfNode;
import com.oracle.svm.core.graal.jdk.SubstrateArraysCopyOfWithExceptionNode;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.lang.reflect.Array;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiArrayNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.ForeignCallWithExceptionNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public final class SubstrateArraysCopyOfSnippets
extends SubstrateTemplates
implements Snippets {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor ARRAYS_COPY_OF = SnippetRuntime.findForeignCall(SubstrateArraysCopyOfSnippets.class, "doArraysCopyOf", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{ARRAYS_COPY_OF};

    public static void registerForeignCalls(Providers providers, SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(providers, FOREIGN_CALLS);
    }

    public static void registerLowerings(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new SubstrateArraysCopyOfSnippets(options, factories, providers, snippetReflection, lowerings);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static Object doArraysCopyOf(DynamicHub hub, Object original, int originalLength, int newLength) {
        int copiedLength;
        Object newArray = Array.newInstance(DynamicHub.toClass(hub.getComponentHub()), newLength);
        int layoutEncoding = hub.getLayoutEncoding();
        int n = copiedLength = originalLength < newLength ? originalLength : newLength;
        if (LayoutEncoding.isObjectArray(layoutEncoding)) {
            DynamicHub originalHub = KnownIntrinsics.readHub(original);
            if (originalHub == hub || DynamicHub.toClass(hub).isAssignableFrom(DynamicHub.toClass(originalHub))) {
                ArraycopySnippets.objectCopyForward(original, 0, newArray, 0, copiedLength, layoutEncoding);
            } else {
                ArraycopySnippets.objectStoreCheckCopyForward(original, 0, newArray, 0, copiedLength);
            }
        } else {
            ArraycopySnippets.primitiveCopyForward(original, 0, newArray, 0, copiedLength, layoutEncoding);
        }
        return newArray;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callArraysCopyOf(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1, Object var2, int var3, int var4);

    @Snippet
    public static Object arraysCopyOfSnippet(DynamicHub hub, Object original, int originalLength, int newLength) {
        Object result = SubstrateArraysCopyOfSnippets.callArraysCopyOf(ARRAYS_COPY_OF, DynamicHub.toClass(hub), original, originalLength, newLength);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp((Object)result, (int)newLength);
    }

    private SubstrateArraysCopyOfSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        ArraysCopyOfLowering arraysCopyOfLowering = new ArraysCopyOfLowering();
        lowerings.put(SubstrateArraysCopyOfNode.class, arraysCopyOfLowering);
        ArraysCopyOfWithExceptionLowering arraysCopyOfWithExceptionLowering = new ArraysCopyOfWithExceptionLowering();
        lowerings.put(SubstrateArraysCopyOfWithExceptionNode.class, arraysCopyOfWithExceptionLowering);
    }

    protected class ArraysCopyOfWithExceptionLowering
    implements NodeLoweringProvider<SubstrateArraysCopyOfWithExceptionNode> {
        protected ArraysCopyOfWithExceptionLowering() {
        }

        @Override
        public void lower(SubstrateArraysCopyOfWithExceptionNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            ForeignCallWithExceptionNode call = (ForeignCallWithExceptionNode)graph.add((Node)new ForeignCallWithExceptionNode((ForeignCallDescriptor)ARRAYS_COPY_OF, new ValueNode[]{node.getNewArrayType(), node.getOriginal(), node.getOriginalLength(), node.getNewLength()}));
            call.setBci(node.bci());
            call.setStamp(node.stamp(NodeView.DEFAULT));
            graph.replaceWithExceptionSplit((WithExceptionNode)node, (WithExceptionNode)call);
        }
    }

    protected class ArraysCopyOfLowering
    implements NodeLoweringProvider<SubstrateArraysCopyOfNode> {
        private final SnippetTemplate.SnippetInfo arraysCopyOf;

        protected ArraysCopyOfLowering() {
            this.arraysCopyOf = SubstrateArraysCopyOfSnippets.this.snippet(SubstrateArraysCopyOfSnippets.class, "arraysCopyOfSnippet", SubstrateAllocationSnippets.ALLOCATION_LOCATIONS);
        }

        @Override
        public void lower(SubstrateArraysCopyOfNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.arraysCopyOf, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("hub", (Object)node.getNewArrayType());
            args.add("original", (Object)node.getOriginal());
            args.add("originalLength", (Object)node.getOriginalLength());
            args.add("newLength", (Object)node.getNewLength());
            SubstrateArraysCopyOfSnippets.this.template((ValueNode)node, args).instantiate(SubstrateArraysCopyOfSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

