/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.HeapImpl;

final class Timer
implements AutoCloseable {
    private final String name;
    private long openNanos;
    private long closeNanos;
    private long collectedNanos;

    Timer(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Timer open() {
        this.openNanos = System.nanoTime();
        this.closeNanos = 0L;
        return this;
    }

    @Override
    public void close() {
        if (this.openNanos == 0L) {
            this.openNanos = HeapImpl.getChunkProvider().getFirstAllocationTime();
        }
        this.closeNanos = System.nanoTime();
        this.collectedNanos += this.closeNanos - this.openNanos;
    }

    public void reset() {
        this.openNanos = 0L;
        this.closeNanos = 0L;
        this.collectedNanos = 0L;
    }

    public long getFinish() {
        assert (this.closeNanos > 0L) : "Should have closed timer";
        return this.closeNanos;
    }

    long getMeasuredNanos() {
        return this.collectedNanos;
    }

    long getLastIntervalNanos() {
        assert (this.openNanos > 0L) : "Should have opened timer";
        assert (this.closeNanos > 0L) : "Should have closed timer";
        return this.closeNanos - this.openNanos;
    }

    static long getTimeSinceFirstAllocation(long nanos) {
        return nanos - HeapImpl.getChunkProvider().getFirstAllocationTime();
    }
}

