/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.aarch64;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.MemoryUtil;
import com.oracle.svm.core.aarch64.AArch64LibCHelper;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;

public class AArch64CPUFeatureAccess
implements CPUFeatureAccess {
    private static boolean isFeaturePresent(String featureName, AArch64LibCHelper.CPUFeatures cpuFeatures) {
        switch (featureName) {
            case "FP": {
                return cpuFeatures.fFP();
            }
            case "ASIMD": {
                return cpuFeatures.fASIMD();
            }
            case "EVTSTRM": {
                return cpuFeatures.fEVTSTRM();
            }
            case "AES": {
                return cpuFeatures.fAES();
            }
            case "PMULL": {
                return cpuFeatures.fPMULL();
            }
            case "SHA1": {
                return cpuFeatures.fSHA1();
            }
            case "SHA2": {
                return cpuFeatures.fSHA2();
            }
            case "CRC32": {
                return cpuFeatures.fCRC32();
            }
            case "LSE": {
                return cpuFeatures.fLSE();
            }
            case "STXR_PREFETCH": {
                return cpuFeatures.fSTXRPREFETCH();
            }
            case "A53MAC": {
                return cpuFeatures.fA53MAC();
            }
            case "DMB_ATOMICS": {
                return cpuFeatures.fDMBATOMICS();
            }
        }
        throw VMError.shouldNotReachHere("Missing feature check: " + featureName);
    }

    @Platforms(value={Platform.AARCH64.class})
    public static EnumSet<AArch64.CPUFeature> determineHostCPUFeatures() {
        EnumSet<AArch64.CPUFeature> features = EnumSet.noneOf(AArch64.CPUFeature.class);
        AArch64LibCHelper.CPUFeatures cpuFeatures = (AArch64LibCHelper.CPUFeatures)StackValue.get(AArch64LibCHelper.CPUFeatures.class);
        MemoryUtil.fillToMemoryAtomic((Pointer)cpuFeatures, SizeOf.unsigned(AArch64LibCHelper.CPUFeatures.class), (byte)0);
        AArch64LibCHelper.determineCPUFeatures(cpuFeatures);
        for (AArch64.CPUFeature feature : AArch64.CPUFeature.values()) {
            if (!AArch64CPUFeatureAccess.isFeaturePresent(feature.name(), cpuFeatures)) continue;
            features.add(feature);
        }
        return features;
    }

    @Override
    public void verifyHostSupportsArchitecture(Architecture imageArchitecture) {
        AArch64 architecture = (AArch64)imageArchitecture;
        EnumSet<AArch64.CPUFeature> features = AArch64CPUFeatureAccess.determineHostCPUFeatures();
        if (!features.containsAll(architecture.getFeatures())) {
            ArrayList<AArch64.CPUFeature> missingFeatures = new ArrayList<AArch64.CPUFeature>();
            for (AArch64.CPUFeature feature : architecture.getFeatures()) {
                if (features.contains(feature)) continue;
                missingFeatures.add(feature);
            }
            throw VMError.shouldNotReachHere("Current target does not support the following CPU features that are required by the image: " + missingFeatures);
        }
    }

    @Override
    public void enableFeatures(Architecture runtimeArchitecture) {
        AArch64 architecture = (AArch64)runtimeArchitecture;
        EnumSet<AArch64.CPUFeature> features = AArch64CPUFeatureAccess.determineHostCPUFeatures();
        architecture.getFeatures().addAll(features);
    }
}

