/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.util.VMError;

public final class TypeResult<T> {
    private final String name;
    private final T type;
    private final Throwable exception;

    public static <V> TypeResult<V> forType(String name, V type) {
        return new TypeResult<V>(name, type);
    }

    public static TypeResult<Class<?>> forClass(Class<?> clazz) {
        return new TypeResult(clazz.getName(), clazz);
    }

    public static TypeResult<Class<?>> forException(String name, Throwable exception) {
        return new TypeResult<Object>(name, null, exception);
    }

    private TypeResult(String name, T type) {
        this(name, type, null);
    }

    private TypeResult(String name, T type, Throwable exception) {
        this.name = name;
        this.type = type;
        this.exception = exception;
    }

    public boolean isPresent() {
        return this.type != null;
    }

    public T get() {
        return this.type;
    }

    public Throwable getException() {
        return this.exception;
    }

    public T getOrFail() {
        if (this.type != null) {
            return this.type;
        }
        throw VMError.shouldNotReachHere("Type " + this.name + " not found", this.exception);
    }
}

