/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.tools.agentscript.impl.NullObject;

@ExportLibrary(value=InteropLibrary.class)
final class VariablesObject
implements TruffleObject {
    final Object scope;
    private final Object returnValue;

    VariablesObject(Object scope, Object returnValue) {
        this.scope = scope;
        this.returnValue = returnValue;
    }

    Object getReturnValue() {
        return NullObject.nullCheck(this.returnValue);
    }

    @ExportMessage
    static boolean hasMembers(VariablesObject obj) {
        return true;
    }

    @ExportMessage
    static Object getMembers(VariablesObject obj, boolean includeInternal, @CachedLibrary(value="obj.scope") InteropLibrary interop) throws UnsupportedMessageException {
        return interop.getMembers(obj.scope);
    }

    @ExportMessage
    static Object readMember(VariablesObject obj, String member, @CachedLibrary(value="obj.scope") InteropLibrary interop) throws UnknownIdentifierException, UnsupportedMessageException {
        return interop.readMember(obj.scope, member);
    }

    @ExportMessage
    static boolean isMemberReadable(VariablesObject obj, String member, @CachedLibrary(value="obj.scope") InteropLibrary interop) {
        return interop.isMemberReadable(obj.scope, member);
    }

    @ExportMessage
    static void writeMember(VariablesObject obj, String member, Object value, @CachedLibrary(value="obj.scope") InteropLibrary interop) throws UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
        interop.writeMember(obj.scope, member, value);
    }

    @ExportMessage
    static boolean isMemberModifiable(VariablesObject obj, String member, @CachedLibrary(value="obj.scope") InteropLibrary interop) {
        return interop.isMemberModifiable(obj.scope, member);
    }

    @ExportMessage
    static boolean isMemberInsertable(VariablesObject obj, String member, @CachedLibrary(value="obj.scope") InteropLibrary interop) {
        return interop.isMemberInsertable(obj.scope, member);
    }
}

