/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.AgentScript;
import com.oracle.truffle.tools.agentscript.impl.AgentScriptInstrumentOptionDescriptors;
import com.oracle.truffle.tools.agentscript.impl.InsightInstrument;
import java.io.IOException;
import java.util.function.Function;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;

@TruffleInstrument.Registration(id="agentscript", name="Agent Script", version="1.0", services={Function.class, AgentScript.class})
public final class AgentScriptInstrument
extends InsightInstrument
implements AgentScript {
    @Option(stability=OptionStability.EXPERIMENTAL, name="", help="Deprecated. Use --insight!", category=OptionCategory.USER)
    static final OptionKey<String> DEPRECATED = new OptionKey((Object)"");

    @Override
    protected OptionDescriptors getOptionDescriptors() {
        return new AgentScriptInstrumentOptionDescriptors();
    }

    @Override
    OptionKey<String> option() {
        return DEPRECATED;
    }

    @Override
    boolean onlyInsight() {
        return false;
    }

    @Override
    protected void onCreate(TruffleInstrument.Env env) {
        super.onCreate(env);
        try {
            env.err().write("Warning: Option --agentscript is deprecated. Use --insight option.\n".getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AgentScript as = AgentScriptInstrument.maybeProxy(AgentScript.class, this);
        env.registerService((Object)as);
    }

    @Override
    public void registerAgentScript(Source script) {
        this.registerAgentScript(() -> script);
    }
}

