/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode.serialization;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;
import com.oracle.truffle.trufflenode.GraalJSAccess;
import com.oracle.truffle.trufflenode.NativeAccess;
import com.oracle.truffle.trufflenode.serialization.ArrayBufferViewTag;
import com.oracle.truffle.trufflenode.serialization.ErrorTag;
import com.oracle.truffle.trufflenode.serialization.SerializationTag;
import com.oracle.truffle.trufflenode.threading.JavaMessagePortData;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class Serializer {
    static final byte VERSION = -1;
    static final byte LATEST_VERSION = 13;
    static final String NATIVE_UTF16_ENCODING = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? "UTF-16BE" : "UTF-16LE";
    private final long delegate;
    private ByteBuffer buffer = Serializer.allocateBuffer(1024);
    private int nextId;
    private final Map<Object, Integer> objectMap = new IdentityHashMap<Object, Integer>();
    private final Map<Object, Integer> transferMap = new IdentityHashMap<Object, Integer>();
    private boolean treatArrayBufferViewsAsHostObjects;
    private final TruffleLanguage.Env env;
    private final GraalJSAccess access;

    public Serializer(JSContext mainJSContext, GraalJSAccess access, long delegate) {
        this.delegate = delegate;
        this.env = mainJSContext.getRealm().getEnv();
        this.access = access;
    }

    public void setTreatArrayBufferViewsAsHostObjects(boolean treatArrayBufferViewsAsHostObjects) {
        this.treatArrayBufferViewsAsHostObjects = treatArrayBufferViewsAsHostObjects;
    }

    private static ByteBuffer allocateBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    private void ensureFreeSpace(int spaceNeeded) {
        ByteBuffer oldBuffer = this.buffer;
        int capacity = oldBuffer.capacity();
        int capacityNeeded = oldBuffer.position() + spaceNeeded;
        if (capacityNeeded > capacity) {
            int newCapacity = Math.max(capacityNeeded, 2 * capacity);
            ByteBuffer newBuffer = Serializer.allocateBuffer(newCapacity);
            oldBuffer.flip();
            newBuffer.put(oldBuffer);
            this.buffer = newBuffer;
        }
    }

    public void writeHeader() {
        this.ensureFreeSpace(2);
        this.buffer.put((byte)-1);
        this.buffer.put((byte)13);
    }

    private void writeTag(SerializationTag tag) {
        this.writeByte(tag.getTag());
    }

    private void writeTag(ArrayBufferViewTag tag) {
        this.writeByte(tag.getTag());
    }

    private void writeTag(ErrorTag tag) {
        this.writeByte(tag.getTag());
    }

    private void writeByte(byte b) {
        this.ensureFreeSpace(1);
        this.buffer.put(b);
    }

    public void writeValue(Object value) {
        if (value == Boolean.TRUE) {
            this.writeTag(SerializationTag.TRUE);
        } else if (value == Boolean.FALSE) {
            this.writeTag(SerializationTag.FALSE);
        } else if (value == Undefined.instance) {
            this.writeTag(SerializationTag.UNDEFINED);
        } else if (value == Null.instance) {
            this.writeTag(SerializationTag.NULL);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (JSRuntime.isNumber((Object)value)) {
            double doubleValue = ((Number)value).doubleValue();
            this.writeIntOrDouble(doubleValue);
        } else if (JSRuntime.isString((Object)value)) {
            this.writeString(JSRuntime.toString((Object)value));
        } else if (JSRuntime.isBigInt((Object)value)) {
            this.writeTag(SerializationTag.BIG_INT);
            this.writeBigIntContents((BigInt)value);
        } else if (this.env.isHostObject(value) && this.access.getCurrentMessagePortData() != null) {
            JavaMessagePortData messagePort = this.access.getCurrentMessagePortData();
            this.writeTag(SerializationTag.SHARED_JAVA_OBJECT);
            this.writeVarInt(messagePort.getMessagePortDataPointer());
            this.assignId(value);
            messagePort.enqueueJavaRef(this.env.asHostObject(value));
        } else {
            this.writeObject(value);
        }
    }

    private void writeObject(Object object) {
        Integer id = this.objectMap.get(object);
        if (id != null) {
            this.writeTag(SerializationTag.OBJECT_REFERENCE);
            this.writeVarInt(id.intValue());
            return;
        }
        if (!this.treatArrayBufferViewsAsHostObjects && JSArrayBufferView.isJSArrayBufferView((Object)object)) {
            DynamicObject arrayBuffer = JSArrayBufferView.getArrayBuffer((DynamicObject)((DynamicObject)object));
            this.assignId(arrayBuffer);
            if (JSSharedArrayBuffer.isJSSharedArrayBuffer((Object)arrayBuffer)) {
                this.writeJSSharedArrayBuffer(arrayBuffer);
            } else {
                this.writeJSArrayBuffer(arrayBuffer);
            }
        }
        this.assignId(object);
        if (JSDate.isJSDate((Object)object)) {
            this.writeTag(SerializationTag.DATE);
            this.writeDate((DynamicObject)object);
        } else if (JSBoolean.isJSBoolean((Object)object)) {
            this.writeJSBoolean((DynamicObject)object);
        } else if (JSNumber.isJSNumber((Object)object)) {
            this.writeJSNumber((DynamicObject)object);
        } else if (JSBigInt.isJSBigInt((Object)object)) {
            this.writeTag(SerializationTag.BIG_INT_OBJECT);
            this.writeBigIntContents(JSBigInt.valueOf((DynamicObject)((DynamicObject)object)));
        } else if (JSString.isJSString((Object)object)) {
            this.writeJSString((DynamicObject)object);
        } else if (JSRegExp.isJSRegExp((Object)object)) {
            this.writeJSRegExp((DynamicObject)object);
        } else if (JSArrayBuffer.isJSDirectArrayBuffer((Object)object)) {
            this.writeJSArrayBuffer((DynamicObject)object);
        } else if (JSSharedArrayBuffer.isJSSharedArrayBuffer((Object)object)) {
            this.writeJSSharedArrayBuffer((DynamicObject)object);
        } else if (JSMap.isJSMap((Object)object)) {
            this.writeJSMap((DynamicObject)object);
        } else if (JSSet.isJSSet((Object)object)) {
            this.writeJSSet((DynamicObject)object);
        } else if (JSArray.isJSArray((Object)object)) {
            this.writeJSArray((DynamicObject)object);
        } else if (JSArrayBufferView.isJSArrayBufferView((Object)object)) {
            this.writeJSArrayBufferView((DynamicObject)object);
        } else if (JSDataView.isJSDataView((Object)object)) {
            this.writeJSDataView((DynamicObject)object);
        } else if (JSError.isJSError((Object)object)) {
            this.writeJSError((DynamicObject)object);
        } else if (JSProxy.isJSProxy((Object)object)) {
            boolean callable = JSRuntime.isCallableProxy((DynamicObject)((DynamicObject)object));
            String message = (callable ? "[object Function]" : "[object Object]") + " could not be cloned.";
            NativeAccess.throwDataCloneError(this.delegate, message);
        } else if (JSFunction.isJSFunction((Object)object)) {
            NativeAccess.throwDataCloneError(this.delegate, JSRuntime.safeToString((Object)object) + " could not be cloned.");
        } else if (JSDynamicObject.isJSDynamicObject((Object)object)) {
            DynamicObject dynamicObject = (DynamicObject)object;
            if (GraalJSAccess.internalFieldCount(dynamicObject) == 0) {
                this.writeJSObject(dynamicObject);
            } else {
                this.writeHostObject(dynamicObject);
            }
        } else {
            this.writeHostObject(object);
        }
    }

    private void writeInt(int value) {
        this.writeTag(SerializationTag.INT32);
        int zigzag = value << 1 ^ value >> 31;
        this.writeVarInt(Integer.toUnsignedLong(zigzag));
    }

    public void writeVarInt(long value) {
        long rest = value;
        byte[] bytes = new byte[10];
        int idx = 0;
        do {
            byte b = (byte)rest;
            bytes[idx] = b = (byte)(b | 0x80);
            ++idx;
        } while ((rest >>>= 7) != 0L);
        int n = idx - 1;
        bytes[n] = (byte)(bytes[n] & 0x7F);
        this.writeBytes(bytes, idx);
    }

    private void writeBytes(byte[] bytes, int length) {
        this.ensureFreeSpace(length);
        this.buffer.put(bytes, 0, length);
    }

    public void writeBytes(ByteBuffer bytes) {
        this.ensureFreeSpace(bytes.remaining());
        this.buffer.put(bytes);
    }

    public void writeIntOrDouble(double value) {
        if (JSRuntime.doubleIsRepresentableAsInt((double)value)) {
            this.writeInt((int)value);
        } else {
            this.writeTag(SerializationTag.DOUBLE);
            this.writeDouble(value);
        }
    }

    public void writeDouble(double value) {
        this.ensureFreeSpace(8);
        this.buffer.putDouble(value);
    }

    private void writeString(String string) {
        try {
            String encoding;
            SerializationTag tag;
            if (Serializer.isOneByteString(string)) {
                tag = SerializationTag.ONE_BYTE_STRING;
                encoding = "ISO-8859-1";
            } else {
                tag = SerializationTag.TWO_BYTE_STRING;
                encoding = NATIVE_UTF16_ENCODING;
            }
            this.writeTag(tag);
            byte[] bytes = string.getBytes(encoding);
            this.writeVarInt(bytes.length);
            this.writeBytes(bytes, bytes.length);
        }
        catch (UnsupportedEncodingException ueex) {
            throw Errors.shouldNotReachHere();
        }
    }

    private static boolean isOneByteString(String string) {
        for (char c : string.toCharArray()) {
            if (c < '\u0100') continue;
            return false;
        }
        return true;
    }

    private void writeDate(DynamicObject date) {
        assert (JSDate.isJSDate((Object)date));
        this.writeDouble(JSDate.getTimeMillisField((DynamicObject)date));
    }

    private void writeJSBoolean(DynamicObject bool) {
        assert (JSBoolean.isJSBoolean((Object)bool));
        this.writeTag(JSBoolean.valueOf((DynamicObject)bool) ? SerializationTag.TRUE_OBJECT : SerializationTag.FALSE_OBJECT);
    }

    private void writeJSNumber(DynamicObject number) {
        assert (JSNumber.isJSNumber((Object)number));
        double value = JSNumber.valueOf((DynamicObject)number).doubleValue();
        this.writeTag(SerializationTag.NUMBER_OBJECT);
        this.writeDouble(value);
    }

    private void writeJSString(DynamicObject string) {
        assert (JSString.isJSString((Object)string));
        String value = JSString.getString((DynamicObject)string);
        this.writeTag(SerializationTag.STRING_OBJECT);
        this.writeString(value);
    }

    private void writeJSRegExp(DynamicObject regExp) {
        assert (JSRegExp.isJSRegExp((Object)regExp));
        String pattern = GraalJSAccess.regexpPattern(regExp);
        int flags = GraalJSAccess.regexpV8Flags(regExp);
        this.writeTag(SerializationTag.REGEXP);
        this.writeString(pattern);
        this.writeVarInt(flags);
    }

    private void writeJSArrayBuffer(DynamicObject arrayBuffer) {
        assert (JSArrayBuffer.isJSDirectArrayBuffer((Object)arrayBuffer));
        Integer id = this.transferMap.get(arrayBuffer);
        if (id == null) {
            int byteLength = JSArrayBuffer.getDirectByteLength((DynamicObject)arrayBuffer);
            ByteBuffer byteBuffer = JSArrayBuffer.getDirectByteBuffer((DynamicObject)arrayBuffer);
            this.writeTag(SerializationTag.ARRAY_BUFFER);
            this.writeVarInt(byteLength);
            this.ensureFreeSpace(byteLength);
            for (int i = 0; i < byteLength; ++i) {
                this.buffer.put(byteBuffer.get(i));
            }
        } else {
            this.writeTag(SerializationTag.ARRAY_BUFFER_TRANSFER);
            this.writeVarInt(Integer.toUnsignedLong(id));
        }
    }

    private void writeJSSharedArrayBuffer(DynamicObject sharedArrayBuffer) {
        int id = NativeAccess.getSharedArrayBufferId(this.delegate, sharedArrayBuffer);
        this.writeTag(SerializationTag.SHARED_ARRAY_BUFFER);
        this.writeVarInt(id);
    }

    private void writeJSObject(DynamicObject object) {
        assert (JSDynamicObject.isJSDynamicObject((Object)object));
        this.writeTag(SerializationTag.BEGIN_JS_OBJECT);
        List names = JSObject.enumerableOwnNames((DynamicObject)object);
        this.writeJSObjectProperties(object, names);
        this.writeTag(SerializationTag.END_JS_OBJECT);
        this.writeVarInt(names.size());
    }

    private void writeJSObjectProperties(DynamicObject object, List<String> keys) {
        assert (JSDynamicObject.isJSDynamicObject((Object)object));
        for (String key : keys) {
            if (JSRuntime.isArrayIndex((String)key)) {
                this.writeIntOrDouble(Double.parseDouble(key));
            } else {
                this.writeString(key);
            }
            Object value = JSObject.get((DynamicObject)object, (Object)key);
            this.writeValue(value);
        }
    }

    private void writeJSMap(DynamicObject object) {
        assert (JSMap.isJSMap((Object)object));
        this.writeTag(SerializationTag.BEGIN_JS_MAP);
        JSHashMap map = JSMap.getInternalMap((DynamicObject)object);
        JSHashMap.Cursor cursor = map.getEntries();
        int count = 0;
        while (cursor.advance()) {
            ++count;
            this.writeValue(cursor.getKey());
            this.writeValue(cursor.getValue());
        }
        this.writeTag(SerializationTag.END_JS_MAP);
        this.writeVarInt(2 * count);
    }

    private void writeJSSet(DynamicObject object) {
        assert (JSSet.isJSSet((Object)object));
        this.writeTag(SerializationTag.BEGIN_JS_SET);
        JSHashMap map = JSSet.getInternalSet((DynamicObject)object);
        JSHashMap.Cursor cursor = map.getEntries();
        int count = 0;
        while (cursor.advance()) {
            ++count;
            this.writeValue(cursor.getKey());
        }
        this.writeTag(SerializationTag.END_JS_SET);
        this.writeVarInt(count);
    }

    private void writeJSArray(DynamicObject object) {
        int i;
        boolean dense;
        assert (JSArray.isJSArray((Object)object));
        long length = JSAbstractArray.arrayGetLength((DynamicObject)object);
        List<String> names = JSObject.enumerableOwnNames((DynamicObject)object);
        boolean bl = dense = (long)names.size() >= length;
        if (dense) {
            i = 0;
            while ((long)i < length) {
                if (!Integer.toString(i).equals(names.get(i))) {
                    dense = false;
                    break;
                }
                ++i;
            }
        }
        if (dense) {
            names = names.subList((int)length, names.size());
            this.writeTag(SerializationTag.BEGIN_DENSE_JS_ARRAY);
            this.writeVarInt(length);
            i = 0;
            while ((long)i < length) {
                this.writeValue(JSObject.get((DynamicObject)object, (long)i));
                ++i;
            }
            this.writeJSObjectProperties(object, names);
            this.writeTag(SerializationTag.END_DENSE_JS_ARRAY);
        } else {
            this.writeTag(SerializationTag.BEGIN_SPARSE_JS_ARRAY);
            this.writeVarInt(length);
            this.writeJSObjectProperties(object, names);
            this.writeTag(SerializationTag.END_SPARSE_JS_ARRAY);
        }
        this.writeVarInt(names.size());
        this.writeVarInt(length);
    }

    private void writeJSArrayBufferView(DynamicObject view) {
        if (this.treatArrayBufferViewsAsHostObjects) {
            this.writeHostObject(view);
        } else {
            int offset = JSArrayBufferView.typedArrayGetOffset((DynamicObject)view);
            TypedArray typedArray = JSArrayBufferView.typedArrayGetArrayType((DynamicObject)view);
            int length = typedArray.lengthInt(view) * typedArray.bytesPerElement();
            ArrayBufferViewTag tag = ArrayBufferViewTag.fromFactory(typedArray.getFactory());
            this.writeJSArrayBufferView(tag, offset, length);
        }
    }

    private void writeJSDataView(DynamicObject view) {
        if (this.treatArrayBufferViewsAsHostObjects) {
            this.writeTag(SerializationTag.HOST_OBJECT);
            NativeAccess.writeHostObject(this.delegate, view);
        } else {
            int offset = JSDataView.typedArrayGetOffset((DynamicObject)view);
            int length = JSDataView.typedArrayGetLength((DynamicObject)view);
            this.writeJSArrayBufferView(ArrayBufferViewTag.DATA_VIEW, offset, length);
        }
    }

    private void writeJSArrayBufferView(ArrayBufferViewTag tag, int offset, int length) {
        this.writeTag(SerializationTag.ARRAY_BUFFER_VIEW);
        this.writeTag(tag);
        this.writeVarInt(offset);
        this.writeVarInt(length);
    }

    private void writeBigIntContents(BigInt value) {
        int bytes;
        boolean negative;
        BigInteger bigInteger = value.bigIntegerValue();
        boolean bl = negative = bigInteger.signum() == -1;
        if (negative) {
            bigInteger = bigInteger.negate();
        }
        int bitLength = bigInteger.bitLength();
        int digits = (bitLength + 63) / 64;
        int bitfield = bytes = digits * 8;
        bitfield <<= 1;
        if (negative) {
            ++bitfield;
        }
        this.writeVarInt(bitfield);
        for (int i = 0; i < bytes; ++i) {
            byte b = 0;
            for (int bit = 8 * (i + 1) - 1; bit >= 8 * i; --bit) {
                b = (byte)(b << 1);
                if (!bigInteger.testBit(bit)) continue;
                b = (byte)(b + 1);
            }
            this.writeByte(b);
        }
    }

    private void writeJSError(DynamicObject error) {
        Object stack;
        this.writeTag(SerializationTag.ERROR);
        this.writeErrorTypeTag(error);
        PropertyDescriptor desc = JSObject.getOwnProperty((DynamicObject)error, (Object)"message");
        if (desc != null && desc.isDataDescriptor()) {
            this.writeTag(ErrorTag.MESSAGE);
            String message = JSRuntime.toString((Object)desc.getValue());
            this.writeString(message);
        }
        if (JSRuntime.isString((Object)(stack = JSObject.get((DynamicObject)error, (Object)"stack")))) {
            this.writeTag(ErrorTag.STACK);
            this.writeString(JSRuntime.toStringIsString((Object)stack));
        }
        this.writeTag(ErrorTag.END);
    }

    private void writeErrorTypeTag(DynamicObject error) {
        ErrorTag tag;
        GraalJSException exception = JSError.getException((DynamicObject)error);
        JSErrorType errorType = JSErrorType.Error;
        if (exception instanceof JSException) {
            errorType = ((JSException)exception).getErrorType();
        }
        switch (errorType) {
            case EvalError: {
                tag = ErrorTag.EVAL_ERROR;
                break;
            }
            case RangeError: {
                tag = ErrorTag.RANGE_ERROR;
                break;
            }
            case ReferenceError: {
                tag = ErrorTag.REFERENCE_ERROR;
                break;
            }
            case SyntaxError: {
                tag = ErrorTag.SYNTAX_ERROR;
                break;
            }
            case TypeError: {
                tag = ErrorTag.TYPE_ERROR;
                break;
            }
            case URIError: {
                tag = ErrorTag.URI_ERROR;
                break;
            }
            default: {
                tag = null;
                assert (errorType == JSErrorType.Error || errorType == JSErrorType.AggregateError);
                break;
            }
        }
        if (tag != null) {
            this.writeTag(tag);
        }
    }

    private void writeHostObject(Object object) {
        this.writeTag(SerializationTag.HOST_OBJECT);
        NativeAccess.writeHostObject(this.delegate, object);
    }

    public void transferArrayBuffer(int id, Object arrayBuffer) {
        this.transferMap.put(arrayBuffer, id);
    }

    public int size() {
        return this.buffer.position();
    }

    public void release(ByteBuffer targetBuffer) {
        this.buffer.flip();
        targetBuffer.put(this.buffer);
    }

    private void assignId(Object object) {
        this.objectMap.put(object, this.nextId++);
    }
}

