/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import com.oracle.truffle.tools.chromeinspector.types.TypeInfo;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

final class ObjectPreview {
    private static final int OVERFLOW_LIMIT_PROPERTIES = 5;
    private static final int OVERFLOW_LIMIT_ARRAY_ELEMENTS = 100;

    private ObjectPreview() {
    }

    static JSONObject create(DebugValue debugValue, String type, String subtype, boolean allowToStringSideEffects, LanguageInfo language, PrintWriter err) {
        boolean overflow;
        JSONObject json = new JSONObject();
        json.put("type", (Object)type);
        json.put("subtype", (Object)subtype);
        boolean isArray = debugValue.isArray();
        DebugValue metaObject = RemoteObject.getMetaObject(debugValue, language, err);
        String metaType = null;
        if (metaObject != null) {
            metaType = RemoteObject.toMetaName(metaObject, err);
            if (isArray) {
                metaType = metaType + "(" + debugValue.getArray().size() + ")";
            }
        }
        json.putOpt("description", (Object)metaType);
        JSONArray properties = new JSONArray();
        if (isArray) {
            List array = debugValue.getArray();
            int size = array.size();
            overflow = size > 100;
            int n = Math.min(size, 100);
            for (int i = 0; i < n; ++i) {
                try {
                    properties.put((Object)ObjectPreview.createPropertyPreview((DebugValue)array.get(i), allowToStringSideEffects, language, err));
                    continue;
                }
                catch (DebugException ex) {
                    overflow = true;
                    break;
                }
            }
        } else {
            Collection valueProperties = debugValue.getProperties();
            if (valueProperties != null) {
                Iterator propertyIterator = valueProperties.iterator();
                overflow = false;
                while (propertyIterator.hasNext()) {
                    DebugValue property = (DebugValue)propertyIterator.next();
                    if (property.isInternal() || property.hasReadSideEffects() || !property.isReadable()) continue;
                    if (properties.length() == 5) {
                        overflow = true;
                        break;
                    }
                    try {
                        properties.put((Object)ObjectPreview.createPropertyPreview(property, allowToStringSideEffects, language, err));
                    }
                    catch (DebugException ex) {
                        overflow = true;
                        break;
                    }
                }
            } else {
                overflow = false;
            }
        }
        json.put("overflow", overflow);
        json.put("properties", (Object)properties);
        return json;
    }

    private static JSONObject createPropertyPreview(DebugValue origProperty, boolean allowToStringSideEffects, LanguageInfo language, PrintWriter err) {
        String value;
        DebugValue property = origProperty;
        if (language != null) {
            property = property.asInLanguage(language);
        }
        JSONObject json = new JSONObject();
        json.put("name", (Object)property.getName());
        boolean isArray = property.isArray();
        TypeInfo typeInfo = TypeInfo.fromValue(property, language, err);
        json.put("type", (Object)typeInfo.type);
        json.putOpt("subtype", (Object)typeInfo.subtype);
        if (isArray) {
            String size = "(" + property.getArray().size() + ")";
            value = typeInfo.descriptionType != null ? typeInfo.descriptionType + size : size;
        } else {
            value = RemoteObject.toString(property, allowToStringSideEffects, err);
        }
        json.putOpt("value", (Object)value);
        return json;
    }
}

