/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugStackTraceElement;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.ScriptsHandler;
import com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import com.oracle.truffle.tools.chromeinspector.types.StackTrace;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public final class ExceptionDetails {
    private static final AtomicLong LAST_ID = new AtomicLong(0L);
    private final DebugException debugException;
    private final String errorMessage;
    private final long exceptionId;

    public ExceptionDetails(DebugException debugException) {
        this.debugException = debugException;
        this.errorMessage = debugException.getLocalizedMessage();
        this.exceptionId = LAST_ID.incrementAndGet();
    }

    public ExceptionDetails(String errorMessage) {
        this.debugException = null;
        this.errorMessage = errorMessage;
        this.exceptionId = LAST_ID.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject createJSON(InspectorExecutionContext context, boolean generatePreview) {
        DebugValue exceptionObject;
        SourceSection throwLocation;
        JSONObject json = new JSONObject();
        json.put("exceptionId", this.exceptionId);
        if (this.debugException == null || this.debugException.getCatchLocation() != null) {
            json.put("text", (Object)"Caught");
        } else {
            json.put("text", (Object)"Uncaught");
        }
        SourceSection sourceSection = throwLocation = this.debugException != null ? this.debugException.getThrowLocation() : null;
        if (throwLocation != null) {
            int scriptId;
            json.put("lineNumber", throwLocation.getStartLine() - 1);
            json.put("columnNumber", throwLocation.getStartColumn() - 1);
            ScriptsHandler sch = context.acquireScriptsHandler();
            try {
                scriptId = sch.getScriptId(throwLocation.getSource());
            }
            finally {
                context.releaseScriptsHandler();
            }
            if (scriptId >= 0) {
                json.put("scriptId", (Object)Integer.toString(scriptId));
            } else {
                ScriptsHandler scriptsHandler = context.acquireScriptsHandler();
                try {
                    json.put("url", (Object)scriptsHandler.getSourceURL(throwLocation.getSource()));
                }
                finally {
                    context.releaseScriptsHandler();
                }
            }
        }
        if (this.debugException != null) {
            List<List<DebugStackTraceElement>> stacks;
            List stack = this.debugException.getDebugStackTrace();
            List asyncStacks = this.debugException.getDebugAsynchronousStacks();
            if (asyncStacks.isEmpty()) {
                stacks = Collections.singletonList(stack);
            } else {
                stacks = new ArrayList<List>();
                stacks.add(stack);
                stacks.addAll(asyncStacks);
            }
            StackTrace stackTrace = new StackTrace(context, stacks);
            json.put("stackTrace", (Object)stackTrace.toJSON());
        }
        DebugValue debugValue = exceptionObject = this.debugException != null ? this.debugException.getExceptionObject() : null;
        if (exceptionObject != null) {
            RemoteObject ro = context.createAndRegister(exceptionObject, generatePreview);
            json.put("exception", (Object)ro.toJSON());
        } else {
            JSONObject ex = new JSONObject();
            ex.put("description", (Object)this.errorMessage);
            ex.put("value", (Object)this.errorMessage);
            ex.put("type", (Object)"string");
            json.put("exception", (Object)ex);
        }
        json.put("executionContextId", context.getId());
        return json;
    }

    public static void resetIDs() {
        LAST_ID.set(0L);
    }
}

