/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Checksum;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Source
extends JSONBase {
    Source(JSONObject jsonData) {
        super(jsonData);
    }

    public String getName() {
        return this.jsonData.optString("name", null);
    }

    public Source setName(String name) {
        this.jsonData.putOpt("name", name);
        return this;
    }

    public String getPath() {
        return this.jsonData.optString("path", null);
    }

    public Source setPath(String path) {
        this.jsonData.putOpt("path", path);
        return this;
    }

    public Integer getSourceReference() {
        return this.jsonData.has("sourceReference") ? Integer.valueOf(this.jsonData.getInt("sourceReference")) : null;
    }

    public Source setSourceReference(Integer sourceReference) {
        this.jsonData.putOpt("sourceReference", sourceReference);
        return this;
    }

    public String getPresentationHint() {
        return this.jsonData.optString("presentationHint", null);
    }

    public Source setPresentationHint(String presentationHint) {
        this.jsonData.putOpt("presentationHint", presentationHint);
        return this;
    }

    public String getOrigin() {
        return this.jsonData.optString("origin", null);
    }

    public Source setOrigin(String origin) {
        this.jsonData.putOpt("origin", origin);
        return this;
    }

    public List<Source> getSources() {
        JSONArray json = this.jsonData.optJSONArray("sources");
        if (json == null) {
            return null;
        }
        ArrayList<Source> list = new ArrayList<Source>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new Source(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public Source setSources(List<Source> sources) {
        if (sources != null) {
            JSONArray json = new JSONArray();
            for (Source source : sources) {
                json.put(source.jsonData);
            }
            this.jsonData.put("sources", json);
        }
        return this;
    }

    public Object getAdapterData() {
        return this.jsonData.opt("adapterData");
    }

    public Source setAdapterData(Object adapterData) {
        this.jsonData.putOpt("adapterData", adapterData);
        return this;
    }

    public List<Checksum> getChecksums() {
        JSONArray json = this.jsonData.optJSONArray("checksums");
        if (json == null) {
            return null;
        }
        ArrayList<Checksum> list = new ArrayList<Checksum>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new Checksum(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public Source setChecksums(List<Checksum> checksums) {
        if (checksums != null) {
            JSONArray json = new JSONArray();
            for (Checksum checksum : checksums) {
                json.put(checksum.jsonData);
            }
            this.jsonData.put("checksums", json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Source other = (Source)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getPath(), other.getPath())) {
            return false;
        }
        if (!Objects.equals(this.getSourceReference(), other.getSourceReference())) {
            return false;
        }
        if (!Objects.equals(this.getPresentationHint(), other.getPresentationHint())) {
            return false;
        }
        if (!Objects.equals(this.getOrigin(), other.getOrigin())) {
            return false;
        }
        if (!Objects.equals(this.getSources(), other.getSources())) {
            return false;
        }
        if (!Objects.equals(this.getAdapterData(), other.getAdapterData())) {
            return false;
        }
        return Objects.equals(this.getChecksums(), other.getChecksums());
    }

    public int hashCode() {
        int hash = 5;
        if (this.getName() != null) {
            hash = 37 * hash + Objects.hashCode(this.getName());
        }
        if (this.getPath() != null) {
            hash = 37 * hash + Objects.hashCode(this.getPath());
        }
        if (this.getSourceReference() != null) {
            hash = 37 * hash + Integer.hashCode(this.getSourceReference());
        }
        if (this.getPresentationHint() != null) {
            hash = 37 * hash + Objects.hashCode(this.getPresentationHint());
        }
        if (this.getOrigin() != null) {
            hash = 37 * hash + Objects.hashCode(this.getOrigin());
        }
        if (this.getSources() != null) {
            hash = 37 * hash + Objects.hashCode(this.getSources());
        }
        if (this.getAdapterData() != null) {
            hash = 37 * hash + Objects.hashCode(this.getAdapterData());
        }
        if (this.getChecksums() != null) {
            hash = 37 * hash + Objects.hashCode(this.getChecksums());
        }
        return hash;
    }

    public static Source create() {
        JSONObject json = new JSONObject();
        return new Source(json);
    }
}

