/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.dap.types.Scope;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ScopesResponse
extends Response {
    ScopesResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public ScopesResponse setBody(ResponseBody body) {
        this.jsonData.put("body", body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScopesResponse other = (ScopesResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + Objects.hashCode(this.getBody());
        hash = 31 * hash + Objects.hashCode(this.getType());
        hash = 31 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 31 * hash + Boolean.hashCode(this.isSuccess());
        hash = 31 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 31 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 31 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ScopesResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", body.jsonData);
        json.put("type", "response");
        json.put("request_seq", requestSeq);
        json.put("success", success);
        json.put("command", command);
        json.put("seq", seq);
        return new ScopesResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public List<Scope> getScopes() {
            JSONArray json = this.jsonData.getJSONArray("scopes");
            ArrayList<Scope> list = new ArrayList<Scope>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                list.add(new Scope(json.getJSONObject(i)));
            }
            return Collections.unmodifiableList(list);
        }

        public ResponseBody setScopes(List<Scope> scopes) {
            JSONArray json = new JSONArray();
            for (Scope scope : scopes) {
                json.put(scope.jsonData);
            }
            this.jsonData.put("scopes", json);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            return Objects.equals(this.getScopes(), other.getScopes());
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + Objects.hashCode(this.getScopes());
            return hash;
        }

        public static ResponseBody create(List<Scope> scopes) {
            JSONObject json = new JSONObject();
            JSONArray scopesJsonArr = new JSONArray();
            for (Scope scope : scopes) {
                scopesJsonArr.put(scope.jsonData);
            }
            json.put("scopes", scopesJsonArr);
            return new ResponseBody(json);
        }
    }
}

