/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Source;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class LoadedSourceEvent
extends Event {
    LoadedSourceEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public EventBody getBody() {
        return new EventBody(this.jsonData.getJSONObject("body"));
    }

    public LoadedSourceEvent setBody(EventBody body) {
        this.jsonData.put("body", body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadedSourceEvent other = (LoadedSourceEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + Objects.hashCode(this.getEvent());
        hash = 23 * hash + Objects.hashCode(this.getBody());
        hash = 23 * hash + Objects.hashCode(this.getType());
        hash = 23 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static LoadedSourceEvent create(EventBody body, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", "loadedSource");
        json.put("body", body.jsonData);
        json.put("type", "event");
        json.put("seq", seq);
        return new LoadedSourceEvent(json);
    }

    public static class EventBody
    extends JSONBase {
        EventBody(JSONObject jsonData) {
            super(jsonData);
        }

        public String getReason() {
            return this.jsonData.getString("reason");
        }

        public EventBody setReason(String reason) {
            this.jsonData.put("reason", reason);
            return this;
        }

        public Source getSource() {
            return new Source(this.jsonData.getJSONObject("source"));
        }

        public EventBody setSource(Source source) {
            this.jsonData.put("source", source.jsonData);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventBody other = (EventBody)obj;
            if (!Objects.equals(this.getReason(), other.getReason())) {
                return false;
            }
            return Objects.equals(this.getSource(), other.getSource());
        }

        public int hashCode() {
            int hash = 2;
            hash = 97 * hash + Objects.hashCode(this.getReason());
            hash = 97 * hash + Objects.hashCode(this.getSource());
            return hash;
        }

        public static EventBody create(String reason, Source source) {
            JSONObject json = new JSONObject();
            json.put("reason", reason);
            json.put("source", source.jsonData);
            return new EventBody(json);
        }
    }
}

