/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.SuppressFBWarnings;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ExceptionPathSegment
extends JSONBase {
    ExceptionPathSegment(JSONObject jsonData) {
        super(jsonData);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getNegate() {
        return this.jsonData.has("negate") ? Boolean.valueOf(this.jsonData.getBoolean("negate")) : null;
    }

    public ExceptionPathSegment setNegate(Boolean negate) {
        this.jsonData.putOpt("negate", negate);
        return this;
    }

    public List<String> getNames() {
        JSONArray json = this.jsonData.getJSONArray("names");
        ArrayList<String> list = new ArrayList<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(json.getString(i));
        }
        return Collections.unmodifiableList(list);
    }

    public ExceptionPathSegment setNames(List<String> names) {
        JSONArray json = new JSONArray();
        for (String string : names) {
            json.put(string);
        }
        this.jsonData.put("names", json);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionPathSegment other = (ExceptionPathSegment)obj;
        if (!Objects.equals(this.getNegate(), other.getNegate())) {
            return false;
        }
        return Objects.equals(this.getNames(), other.getNames());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getNegate() != null) {
            hash = 37 * hash + Boolean.hashCode(this.getNegate());
        }
        hash = 37 * hash + Objects.hashCode(this.getNames());
        return hash;
    }

    public static ExceptionPathSegment create(List<String> names) {
        JSONObject json = new JSONObject();
        JSONArray namesJsonArr = new JSONArray();
        for (String string : names) {
            namesJsonArr.put(string);
        }
        json.put("names", namesJsonArr);
        return new ExceptionPathSegment(json);
    }
}

