/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ExceptionDetails
extends JSONBase {
    ExceptionDetails(JSONObject jsonData) {
        super(jsonData);
    }

    public String getMessage() {
        return this.jsonData.optString("message", null);
    }

    public ExceptionDetails setMessage(String message) {
        this.jsonData.putOpt("message", message);
        return this;
    }

    public String getTypeName() {
        return this.jsonData.optString("typeName", null);
    }

    public ExceptionDetails setTypeName(String typeName) {
        this.jsonData.putOpt("typeName", typeName);
        return this;
    }

    public String getFullTypeName() {
        return this.jsonData.optString("fullTypeName", null);
    }

    public ExceptionDetails setFullTypeName(String fullTypeName) {
        this.jsonData.putOpt("fullTypeName", fullTypeName);
        return this;
    }

    public String getEvaluateName() {
        return this.jsonData.optString("evaluateName", null);
    }

    public ExceptionDetails setEvaluateName(String evaluateName) {
        this.jsonData.putOpt("evaluateName", evaluateName);
        return this;
    }

    public String getStackTrace() {
        return this.jsonData.optString("stackTrace", null);
    }

    public ExceptionDetails setStackTrace(String stackTrace) {
        this.jsonData.putOpt("stackTrace", stackTrace);
        return this;
    }

    public List<ExceptionDetails> getInnerException() {
        JSONArray json = this.jsonData.optJSONArray("innerException");
        if (json == null) {
            return null;
        }
        ArrayList<ExceptionDetails> list = new ArrayList<ExceptionDetails>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            list.add(new ExceptionDetails(json.getJSONObject(i)));
        }
        return Collections.unmodifiableList(list);
    }

    public ExceptionDetails setInnerException(List<ExceptionDetails> innerException) {
        if (innerException != null) {
            JSONArray json = new JSONArray();
            for (ExceptionDetails exceptionDetails : innerException) {
                json.put(exceptionDetails.jsonData);
            }
            this.jsonData.put("innerException", json);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionDetails other = (ExceptionDetails)obj;
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        if (!Objects.equals(this.getTypeName(), other.getTypeName())) {
            return false;
        }
        if (!Objects.equals(this.getFullTypeName(), other.getFullTypeName())) {
            return false;
        }
        if (!Objects.equals(this.getEvaluateName(), other.getEvaluateName())) {
            return false;
        }
        if (!Objects.equals(this.getStackTrace(), other.getStackTrace())) {
            return false;
        }
        return Objects.equals(this.getInnerException(), other.getInnerException());
    }

    public int hashCode() {
        int hash = 7;
        if (this.getMessage() != null) {
            hash = 53 * hash + Objects.hashCode(this.getMessage());
        }
        if (this.getTypeName() != null) {
            hash = 53 * hash + Objects.hashCode(this.getTypeName());
        }
        if (this.getFullTypeName() != null) {
            hash = 53 * hash + Objects.hashCode(this.getFullTypeName());
        }
        if (this.getEvaluateName() != null) {
            hash = 53 * hash + Objects.hashCode(this.getEvaluateName());
        }
        if (this.getStackTrace() != null) {
            hash = 53 * hash + Objects.hashCode(this.getStackTrace());
        }
        if (this.getInnerException() != null) {
            hash = 53 * hash + Objects.hashCode(this.getInnerException());
        }
        return hash;
    }

    public static ExceptionDetails create() {
        JSONObject json = new JSONObject();
        return new ExceptionDetails(json);
    }
}

